/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;

public class NuggetRegistry {
    private static ArrayList<NuggetInfo> nuggets = Lists.newArrayList();

    public static void init() {
        NuggetRegistry.registerNugget("diamond_nugget", "nuggetDiamond", "item.diamond", true);
        NuggetRegistry.registerNugget("iron_nugget", "nuggetIron", "item.ingotIron", true);
        NuggetRegistry.registerNugget("emerald_nugget", "nuggetEmerald", "item.emerald", true);
        NuggetRegistry.registerNugget("lapis_nugget", "nuggetLapis", "item.dyePowder.blue", true);
        NuggetRegistry.registerNugget("quartz_nugget", "nuggetQuartz", "item.netherquartz", true);
        NuggetRegistry.registerNugget("bronze_nugget_ic2", "nuggetBronze", "ic2.ingot.bronze");
        NuggetRegistry.registerNugget("copper_nugget_ic2", "nuggetCopper", "ic2.ingot.copper");
        NuggetRegistry.registerNugget("tin_nugget_ic2", "nuggetTin", "ic2.ingot.tin");
        NuggetRegistry.registerNugget("steel_nugget_ic2", "nuggetSteel", "ic2.ingot.steel");
        NuggetRegistry.registerNugget("lead_nugget_ic2", "nuggetLead", "ic2.ingot.lead");
        NuggetRegistry.registerNugget("tin_nugget_forestry", "nuggetTin", "item.for.ingotTin");
        NuggetRegistry.registerNugget("bronze_nugget_forestry", "nuggetBronze", "item.for.ingotBronze");
        NuggetRegistry.registerNugget("copper_nugget_forestry", "nuggetCopper", "item.for.ingotCopper");
        NuggetRegistry.registerNugget("silver_nugget_factorization", "nuggetSilver", "item.factorization:silver_ingot");
        NuggetRegistry.registerNugget("lead_nugget_factorization", "nuggetLead", "item.factorization:lead_ingot");
        NuggetRegistry.registerNugget("darkiron_nugget_factorization", "nuggetFzDarkIron", "item.factorization:dark_iron_ingot");
        NuggetRegistry.registerNugget("aluminium_nugget_techreborn", "nuggetAluminium", "item.techreborn.ingot.aluminum");
        NuggetRegistry.registerNugget("brass_nugget_techreborn", "nuggetBrass", "item.techreborn.ingot.brass");
        NuggetRegistry.registerNugget("chrome_nugget_techreborn", "nuggetChrome", "item.techreborn.ingot.chrome");
        NuggetRegistry.registerNugget("copper_nugget_techreborn", "nuggetCopper", "item.techreborn.ingot.copper");
        NuggetRegistry.registerNugget("electrum_nugget_techreborn", "nuggetElectrum", "item.techreborn.ingot.electrum");
        NuggetRegistry.registerNugget("invar_nugget_techreborn", "nuggetInvar", "item.techreborn.ingot.invar");
        NuggetRegistry.registerNugget("iridium_nugget_techreborn", "nuggetIridium", "item.techreborn.ingot.iridium");
        NuggetRegistry.registerNugget("lead_nugget_techreborn", "nuggetLead", "item.techreborn.ingot.lead");
        NuggetRegistry.registerNugget("nickel_nugget_techreborn", "nuggetNickel", "item.techreborn.ingot.nickel");
        NuggetRegistry.registerNugget("platinum_nugget_techreborn", "nuggetPlatinum", "item.techreborn.ingot.platinum");
        NuggetRegistry.registerNugget("silver_nugget_techreborn", "nuggetSilver", "item.techreborn.ingot.silver");
        NuggetRegistry.registerNugget("steel_nugget_techreborn", "nuggetSteel", "item.techreborn.ingot.steel");
        NuggetRegistry.registerNugget("tin_nugget_techreborn", "nuggetTin", "item.techreborn.ingot.tin");
        NuggetRegistry.registerNugget("titanium_nugget_techreborn", "nuggetTitanium", "item.techreborn.ingot.titanium");
        NuggetRegistry.registerNugget("tungsten_nugget_techreborn", "nuggetTungsten", "item.techreborn.ingot.tungsten");
        NuggetRegistry.registerNugget("tungstensteel_nugget_techreborn", "nuggetTungstenSteel", "item.techreborn.ingot.tungstensteel");
        NuggetRegistry.registerNugget("zinc_nugget_techreborn", "nuggetZinc", "item.techreborn.ingot.zinc");
        NuggetRegistry.registerNugget("refinediron_nugget_techreborn", "nuggetRefinedIron", "item.techreborn.ingot.refinedIron");
    }

    public static void registerNugget(String unlocName, String oreName, String ingotName, boolean needed) {
        nuggets.add(new NuggetInfo(unlocName, oreName, ingotName, needed));
    }

    public static void registerNugget(int id, String unlocName, String oreName, String ingotName, boolean needed) {
        nuggets.add(id, new NuggetInfo(unlocName, oreName, ingotName, needed));
    }

    public static void registerNugget(String unlocName, String oreName, String ingotName) {
        NuggetRegistry.registerNugget(unlocName, oreName, ingotName, false);
    }

    public static void registerNugget(int id, String unlocName, String oreName, String ingotName) {
        NuggetRegistry.registerNugget(id, unlocName, oreName, ingotName, false);
    }

    public static ArrayList<NuggetInfo> getNuggets() {
        return nuggets;
    }

    public static void setNeeded(int i, boolean needed) {
        NuggetRegistry.nuggets.get((int)i).needed = needed;
    }

    public static String getUnlocName(int i) {
        return NuggetRegistry.nuggets.get((int)i).unlocName;
    }

    public static int size() {
        return nuggets.size();
    }

    public static boolean getNeeded(int i) {
        return NuggetRegistry.nuggets.get((int)i).needed;
    }

    public static String getIngotName(int i) {
        return NuggetRegistry.nuggets.get((int)i).ingotName;
    }

    public static String getOreName(int i) {
        return NuggetRegistry.nuggets.get((int)i).oreName;
    }

    public static ArrayList<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (NuggetInfo nugget : nuggets) {
            names.add("nuggets/" + nugget.unlocName);
        }
        return names;
    }

    public static class NuggetInfo {
        public String unlocName;
        public String oreName;
        public String ingotName;
        public boolean needed;

        public NuggetInfo(String unlocName, String oreName, String ingotName, boolean needed) {
            this.unlocName = unlocName;
            this.oreName = oreName;
            this.ingotName = ingotName;
            this.needed = needed;
        }
    }
}

