/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.api;

import gory_moon.moarsigns.api.ISignRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class IntegrationRegistry {
    private static ArrayList<ISignRegistration> signReg = new ArrayList();
    private static HashSet<String> woodNames = new HashSet();
    private static HashSet<String> metalNames = new HashSet();

    public static <T extends ISignRegistration> void registerIntegration(Class<T> clazz) {
        try {
            IntegrationRegistry.registerIntegration((ISignRegistration)clazz.newInstance());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void registerIntegration(ISignRegistration registration) {
        signReg.add(registration);
    }

    public static void registerPlankOreName(String name) {
        woodNames.add(name);
    }

    public static void registerMetalGemOreName(String ... names) {
        Collections.addAll(metalNames, names);
    }

    public static ArrayList<ISignRegistration> getSignReg() {
        return (ArrayList)signReg.clone();
    }

    public static ArrayList<String> getMetalNames() {
        return new ArrayList<String>(metalNames);
    }

    public static ArrayList<String> getWoodNames() {
        return new ArrayList<String>(woodNames);
    }

    public static ISignRegistration getWithTag(String tag) {
        for (ISignRegistration registration : signReg) {
            if (registration.getActivateTag() == null || !registration.getActivateTag().equals(tag)) continue;
            return registration;
        }
        return null;
    }
}

