package gory_moon.moarsigns.integration.vanilla;

import gory_moon.moarsigns.api.ISignRegistration;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.lib.ModInfo;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

import java.util.ArrayList;

public class MinecraftIntegration implements ISignRegistration {

    @Override
    public void registerWoodenSigns(ArrayList<ItemStack> planks) {

        Item vanillaItem = null;
        for (ItemStack plank : planks) {
            if (plank.func_77977_a().equals("tile.wood.oak")) {
                vanillaItem = plank.func_77946_l().func_77973_b();
                break;
            }
        }

        SignRegistry.register("oak_sign", null, "oak", "", false, new ItemStack(vanillaItem, 1, 0), ModInfo.ID);
        SignRegistry.register("spruce_sign", null, "spruce", "", false, new ItemStack(vanillaItem, 1, 1), ModInfo.ID);
        SignRegistry.register("birch_sign", null, "birch", "", false, new ItemStack(vanillaItem, 1, 2), ModInfo.ID);
        SignRegistry.register("jungle_sign", null, "jungle", "", false, new ItemStack(vanillaItem, 1, 3), ModInfo.ID);
        SignRegistry.register("acacia_sign", null, "acacia", "", false, new ItemStack(vanillaItem, 1, 4), ModInfo.ID);
        SignRegistry.register("big_oak_sign", null, "big_oak", "", false, new ItemStack(vanillaItem, 1, 5), ModInfo.ID);
    }

    @Override
    public void registerMetalSigns(ArrayList<ItemStack> metals) {
        SignRegistry.register("iron_sign", null, "iron", "", false, new ItemStack(Items.field_151042_j), new ItemStack(Blocks.field_150339_S), ModInfo.ID).setMetal();
        SignRegistry.register("gold_sign", null, "gold", "", true, new ItemStack(Items.field_151043_k), new ItemStack(Blocks.field_150340_R), ModInfo.ID).setMetal();
        SignRegistry.register("diamond_sign", null, "diamond", "", false, new ItemStack(Items.field_151045_i), new ItemStack(Blocks.field_150484_ah), ModInfo.ID).setMetal();
        SignRegistry.register("emerald_sign", null, "emerald", "", false, new ItemStack(Items.field_151166_bC), new ItemStack(Blocks.field_150475_bE), ModInfo.ID).setMetal();
        SignRegistry.register("lapis_sign", null, "lapis", "", false, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), new ItemStack(Blocks.field_150368_y), ModInfo.ID).setMetal();
        SignRegistry.register("quartz_sign", null, "quartz", "", false, new ItemStack(Items.field_151128_bU), new ItemStack(Blocks.field_150371_ca), ModInfo.ID).setMetal();
    }

    @Override
    public String getActivateTag() {
        return SignRegistry.ALWAYS_ACTIVE_TAG;
    }

    @Override
    public String getIntegrationName() {
        return "Minecraft";
    }

    @Override
    public String getModName() {
        return null;
    }
}
