/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.ISignRegistration;
import gory_moon.moarsigns.api.IntegrationRegistry;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.integration.basemetals.BasemetalsIntegration;
import gory_moon.moarsigns.integration.bop.BiomesOPlentyIntegration;
import gory_moon.moarsigns.integration.tconstruct.TinkersConstructIntegration;
import gory_moon.moarsigns.integration.vanilla.MinecraftIntegration;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class IntegrationHandler {
    private static void registerSigns(ArrayList<ItemStack> planks, ArrayList<ItemStack> ingots, boolean log) {
        if (log) {
            MoarSigns.logger.info("Starting sign integrations");
        }
        ArrayList<ISignRegistration> signReg = IntegrationRegistry.getSignReg();
        for (ISignRegistration reg : signReg) {
            reg.registerWoodenSigns(planks);
            reg.registerMetalSigns(ingots);
        }
        for (ISignRegistration reg : signReg) {
            if (reg.getActivateTag() == null || reg.getIntegrationName() == null || !Loader.isModLoaded((String)reg.getActivateTag())) continue;
            SignRegistry.activateTag(reg.getActivateTag());
            if (!log) continue;
            MoarSigns.logger.info("Loaded " + reg.getIntegrationName() + " SignIntegration");
        }
        if (log) {
            MoarSigns.logger.info("Finished " + SignRegistry.getActiveTagsAmount() + " sign integrations with " + SignRegistry.getActivatedSignRegistry().size() + " signs registered");
        }
        SignRegistry.sortRegistry();
    }

    private ArrayList<ItemStack> getOres(ArrayList<String> names) {
        ArrayList<ItemStack> ores = new ArrayList<ItemStack>();
        for (String name : names) {
            ores.addAll(OreDictionary.getOres((String)name));
        }
        return ores;
    }

    public void preSetupSigns() {
        ArrayList<String> names = IntegrationRegistry.getWoodNames();
        ArrayList<ItemStack> planks = this.getOres(names);
        names = IntegrationRegistry.getMetalNames();
        ArrayList<ItemStack> ingots = this.getOres(names);
        IntegrationHandler.registerSigns(planks, ingots, false);
    }

    public void setupSigns() {
        ArrayList<String> names = IntegrationRegistry.getWoodNames();
        ArrayList<ItemStack> planks = this.getOres(names);
        names = IntegrationRegistry.getMetalNames();
        ArrayList<ItemStack> ingots = this.getOres(names);
        IntegrationHandler.registerSigns(planks, ingots, true);
    }

    static {
        IntegrationRegistry.registerIntegration(MinecraftIntegration.class);
        IntegrationRegistry.registerIntegration(BiomesOPlentyIntegration.class);
        IntegrationRegistry.registerIntegration(TinkersConstructIntegration.class);
        IntegrationRegistry.registerIntegration(BasemetalsIntegration.class);
        IntegrationRegistry.registerPlankOreName("plankWood");
        String[] ingotNames = new String[]{"ingotCopper", "ingotTin", "ingotSilver", "ingotBronze", "ingotSteel", "ingotLead", "ingotZinc", "ingotBrass", "ingotCobalt", "ingotArdite", "ingotManyullyn", "ingotAluminum", "ingotAluminumBrass", "ingotAlumite", "ingotNickel", "ingotPlatinum", "ingotMithril", "ingotElectrum", "ingotColdiron", "ingotCupronickel", "ingotMithril", "ingotAdamantine", "ingotStarsteel", "ingotAquarium", "ingotInvar", "ingotSignalum", "ingotLumium", "ingotEnderium", "ingotFzDarkIron"};
        String[] blockNames = new String[]{"blockCopper", "blockTin", "blockSilver", "blockBronze", "blockSteel", "blockLead", "blockZinc", "blockBrass", "blockCobalt", "blockArdite", "blockManyullyn", "blockAluminum", "blockAluminumBrass", "blockAlumite", "blockNickel", "blockPlatinum", "blockMithril", "blockElectrum", "blockColdiron", "blockCupronickel", "blockMithril", "blockAdamantine", "blockStarsteel", "blockAquarium", "blockInvar", "blockSignalum", "blockLumium", "blockEnderium", "blockFzDarkIron"};
        for (String name : ingotNames) {
            IntegrationRegistry.registerMetalGemOreName(name);
        }
        for (String name : blockNames) {
            IntegrationRegistry.registerMetalGemOreName(name);
        }
    }
}

