/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client;

import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.items.NuggetRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class ModelsMoarSigns {
    public static void prepareModels() {
        ArrayList<String> signs = SignRegistry.getTextureLocations(false, false);
        ModelsMoarSigns.addVariantNames(Blocks.signStandingWood, signs.toArray(new String[signs.size()]));
        ModelsMoarSigns.addVariantNames(Blocks.signWallWood, signs.toArray(new String[signs.size()]));
        signs = SignRegistry.getTextureLocations(true, false);
        ModelsMoarSigns.addVariantNames(Blocks.signStandingMetal, signs.toArray(new String[signs.size()]));
        ModelsMoarSigns.addVariantNames(Blocks.signWallMetal, signs.toArray(new String[signs.size()]));
        signs = SignRegistry.getTextureLocations(true);
        ModelsMoarSigns.addVariantModelNames(ModItems.sign, signs.toArray(new String[signs.size()]));
        ArrayList<String> nuggets = NuggetRegistry.getNames();
        ModelsMoarSigns.addVariantNames(ModItems.nugget, nuggets.toArray(new String[nuggets.size()]));
        ModelsMoarSigns.addVariantNames(ModItems.debug, "debug");
        ModelsMoarSigns.addVariantNames(ModItems.signToolbox, "sign_toolbox/edit", "sign_toolbox/rotate", "sign_toolbox/move", "sign_toolbox/copy", "sign_toolbox/exchange", "sign_toolbox/preview");
    }

    public static void registerModels() {
        for (int i = 0; i < NuggetRegistry.getNuggets().size(); ++i) {
            ModelsMoarSigns.registerItemModel(ModItems.nugget, i, ModelsMoarSigns.getResource("nuggets/" + NuggetRegistry.getUnlocName(i)));
        }
        ModelsMoarSigns.registerItemModel(ModItems.debug);
        ModelsMoarSigns.registerItemModel(ModItems.signToolbox, 0, ModelsMoarSigns.getResource("sign_toolbox/edit"));
        ModelsMoarSigns.registerItemModel(ModItems.signToolbox, 1, ModelsMoarSigns.getResource("sign_toolbox/rotate"));
        ModelsMoarSigns.registerItemModel(ModItems.signToolbox, 2, ModelsMoarSigns.getResource("sign_toolbox/move"));
        ModelsMoarSigns.registerItemModel(ModItems.signToolbox, 7, ModelsMoarSigns.getResource("sign_toolbox/move"));
        ModelsMoarSigns.registerItemModel(ModItems.signToolbox, 3, ModelsMoarSigns.getResource("sign_toolbox/copy"));
        ModelsMoarSigns.registerItemModel(ModItems.signToolbox, 4, ModelsMoarSigns.getResource("sign_toolbox/exchange"));
        ModelsMoarSigns.registerItemModel(ModItems.signToolbox, 5, ModelsMoarSigns.getResource("sign_toolbox/preview"));
    }

    private static void addVariantNames(Block block, String ... names) {
        ResourceLocation[] locations = new ResourceLocation[names.length];
        for (int i = 0; i < names.length; ++i) {
            locations[i] = new ResourceLocation(ModelsMoarSigns.getResource(names[i]));
        }
        if (block != null) {
            ModelBakery.registerItemVariants((Item)Item.getItemFromBlock((Block)block), (ResourceLocation[])locations);
        }
    }

    private static void addVariantModelNames(Item item, String ... names) {
        ModelResourceLocation[] locations = new ModelResourceLocation[names.length];
        for (int i = 0; i < names.length; ++i) {
            locations[i] = new ModelResourceLocation(names[i], "inventory");
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])locations);
    }

    private static void addVariantNames(Item item, String ... names) {
        ResourceLocation[] locations = new ResourceLocation[names.length];
        for (int i = 0; i < names.length; ++i) {
            locations[i] = new ResourceLocation(ModelsMoarSigns.getResource(names[i]));
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])locations);
    }

    private static void registerBlockModel(Block block) {
        ResourceLocation resourceLocation = (ResourceLocation)Block.blockRegistry.getNameForObject((Object)block);
        ModelsMoarSigns.registerBlockModel(block, 0, resourceLocation.toString());
    }

    private static void registerItemModel(Item item) {
        ResourceLocation resourceLocation = (ResourceLocation)Item.itemRegistry.getNameForObject((Object)item);
        ModelsMoarSigns.registerItemModel(item, 0, resourceLocation.toString());
    }

    private static void registerBlockModel(Block block, int meta, String modelName) {
        ModelsMoarSigns.registerItemModel(Item.getItemFromBlock((Block)block), meta, modelName);
    }

    private static void registerItemModel(Item item, int meta, String resourcePath) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(resourcePath, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelResourceLocation);
    }

    public static String getResource(String resource) {
        return "moarsigns:" + resource;
    }
}

