/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.MoarSignsCreativeTab;
import gory_moon.moarsigns.blocks.BlockMoarSign;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.lib.ToolBoxModes;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignOpenGui;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.RotationHandler;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemSignToolbox
extends Item {
    public static final String SIGN_MOVING_TAG = "SignMoving";
    public static final String NBT_UNLOCALIZED_NAME = "SignUnlocalizedName";

    public ItemSignToolbox() {
        this.func_77655_b("moarsigns.signtoolbox");
        this.func_77637_a(MoarSignsCreativeTab.tabMS);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public boolean func_77645_m() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            MovingObjectPosition.MovingObjectType hit;
            MovingObjectPosition movingObjectPosition = this.func_77621_a(world, player, false);
            MovingObjectPosition.MovingObjectType movingObjectType = hit = movingObjectPosition != null ? movingObjectPosition.field_72313_a : MovingObjectPosition.MovingObjectType.MISS;
            if (hit == MovingObjectPosition.MovingObjectType.MISS) {
                int mode;
                int n = mode = this.isMoving(stack.func_77952_i()) ? 2 : stack.func_77952_i();
                if (player.func_70093_af() && !this.isMoving(stack.func_77952_i())) {
                    return this.rotateModes(stack);
                }
                if (ToolBoxModes.values()[mode] == ToolBoxModes.EXCHANGE_MODE) {
                    this.doExchange(world, BlockPos.field_177992_a, player);
                } else if (ToolBoxModes.values()[mode] == ToolBoxModes.PREVIEW_MODE) {
                    this.doPreview(world, BlockPos.field_177992_a, player);
                }
            }
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int mode = this.isMoving(stack.func_77952_i()) ? 2 : stack.func_77952_i();
            switch (ToolBoxModes.values()[mode]) {
                case EDIT_MODE: {
                    this.doEdit(world, pos, player);
                    break;
                }
                case ROTATE_MODE: {
                    this.doRotate(world, pos, player);
                    break;
                }
                case MOVE_MODE: {
                    return this.doMove(world, pos, stack, player, side, hitX, hitY, hitZ);
                }
                case COPY_MODE: {
                    this.doCopy(world, pos, stack, player);
                    break;
                }
                case EXCHANGE_MODE: {
                    this.doExchange(world, pos, player);
                    return true;
                }
                case PREVIEW_MODE: {
                    this.doPreview(world, pos, player);
                    return true;
                }
            }
        }
        return false;
    }

    private void doRotate(World world, BlockPos pos, EntityPlayer player) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockMoarSign) {
            RotationHandler.rotate((TileEntityMoarSign)world.func_175625_s(pos), player.func_70093_af());
        }
    }

    private void doEdit(World world, BlockPos pos, EntityPlayer player) {
        TileEntity entity;
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockMoarSign && (entity = world.func_175625_s(pos)) instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileEntity = (TileEntityMoarSign)entity;
            tileEntity.setEditAble(true);
            tileEntity.func_145912_a(player);
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSignOpenGui(tileEntity, false), (EntityPlayerMP)player);
        }
    }

    public void doCopy(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        TileEntity tileEntity;
        NBTTagCompound signInfo = stack.func_77978_p();
        if (player.func_70093_af()) {
            TileEntity tileEntity2 = world.func_175625_s(pos);
            if (tileEntity2 instanceof TileEntityMoarSign) {
                signInfo = new NBTTagCompound();
                tileEntity2.func_145841_b(signInfo);
                signInfo.func_82580_o("texture");
                signInfo.func_82580_o("isMetal");
                stack.func_77982_d(signInfo);
            }
        } else if (signInfo != null && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityMoarSign) {
            tileEntity.func_145839_a(signInfo);
            tileEntity.func_174878_a(pos);
            world.func_175689_h(pos);
        }
    }

    private boolean doMove(World world, BlockPos pos, ItemStack stack, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean val = true;
        NBTTagCompound signInfo = stack.func_77978_p();
        if (!this.isMoving(stack.func_77952_i())) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityMoarSign) {
                TileEntityMoarSign tileEntityMoarSign = (TileEntityMoarSign)tileEntity;
                signInfo = new NBTTagCompound();
                tileEntity.func_145841_b(signInfo);
                ItemStack signStack = ModItems.sign.createMoarItemStack(tileEntityMoarSign.texture_name, tileEntityMoarSign.isMetal);
                String unlocalizedName = signStack.func_77977_a() + ".name";
                signInfo.func_74778_a(NBT_UNLOCALIZED_NAME, unlocalizedName);
                stack = this.toggleMoving(stack);
                tileEntityMoarSign.removeNoDrop = true;
                world.func_175698_g(pos);
            }
        } else {
            String texture = signInfo.func_74779_i("texture");
            boolean isMetal = signInfo.func_74767_n("isMetal");
            ItemStack moarSignsStack = ModItems.sign.createMoarItemStack(texture, isMetal);
            moarSignsStack.func_77978_p().func_74757_a(SIGN_MOVING_TAG, true);
            val = ModItems.sign.func_180614_a(moarSignsStack, player, world, pos, side, hitX, hitY, hitZ);
            if (val) {
                pos = pos.func_177972_a(side);
                signInfo.func_82580_o(NBT_UNLOCALIZED_NAME);
                TileEntityMoarSign entityMoarSign = (TileEntityMoarSign)world.func_175625_s(pos);
                entityMoarSign.func_145839_a(signInfo);
                entityMoarSign.func_174878_a(pos);
                world.func_175689_h(pos);
                signInfo = null;
                stack = this.toggleMoving(stack);
            }
        }
        stack.func_77982_d(signInfo);
        return !val;
    }

    private void doExchange(World world, BlockPos pos, EntityPlayer player) {
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MoarSigns.instance, (int)2, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
    }

    private void doPreview(World world, BlockPos pos, EntityPlayer player) {
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MoarSigns.instance, (int)3, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
    }

    private ItemStack rotateModes(ItemStack stack) {
        int mode = stack.func_77952_i();
        mode = mode + 1 >= 6 ? 0 : mode + 1;
        stack.func_77964_b(mode);
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() > 5 && !this.isMoving(stack.func_77952_i())) {
            stack.func_77964_b(0);
        }
        int mode = this.isMoving(stack.func_77952_i()) ? 2 : stack.func_77952_i();
        return super.func_77667_c(stack) + "." + ToolBoxModes.values()[mode].toString();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInfo) {
        GameSettings gameSettings = FMLClientHandler.instance().getClient().field_71474_y;
        String str = (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.CHANGE.translate((Object)((Object)Colors.LIGHTGRAY) + "[" + GameSettings.func_74298_c((int)gameSettings.field_74311_E.func_151463_i()) + "]" + Colors.GRAY.toString());
        int mode = this.isMoving(stack.func_77952_i()) ? 2 : stack.func_77952_i();
        switch (ToolBoxModes.values()[mode]) {
            case COPY_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.COPY.translate(Colors.LIGHTGRAY.toString() + "[" + GameSettings.func_74298_c((int)gameSettings.field_74311_E.func_151463_i()) + "]" + Colors.GRAY.toString(), Colors.LIGHTGRAY.toString() + "[", "]" + Colors.GRAY.toString(), "\n" + Colors.LIGHTGRAY.toString() + "[");
                if (stack.func_77978_p() == null) break;
                str = str + "\n" + (Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGNTOOLBOX.CURRENT_TEXT.translate(new String[0]) + this.getFormattedData(stack.func_77978_p());
                break;
            }
            case MOVE_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.MOVE.translate(Colors.LIGHTGRAY.toString() + "[", "]" + Colors.GRAY.toString(), "\n" + Colors.GRAY.toString(), "\n" + Colors.RED.toString());
                if (stack.func_77978_p() == null) break;
                String unlocName = stack.func_77978_p().func_74779_i(NBT_UNLOCALIZED_NAME);
                String signName = StatCollector.func_74838_a((String)unlocName);
                str = str + "\n" + (Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGNTOOLBOX.CURRENT_SIGN.translate(new String[0]) + " " + (Object)((Object)Colors.WHITE) + signName + "\n" + (Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGNTOOLBOX.CURRENT_TEXT.translate(new String[0]) + this.getFormattedData(stack.func_77978_p());
                break;
            }
            case EXCHANGE_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.EXCHANGE.translate("\n" + Colors.GRAY.toString());
                break;
            }
            case PREVIEW_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.PREVIEW.translate("\n" + Colors.GRAY.toString());
                break;
            }
            default: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.values()[stack.func_77952_i() + 1].translate(Colors.LIGHTGRAY.toString(), Colors.GRAY.toString());
            }
        }
        String[] strList = str.split("\n");
        for (int i = 0; i < strList.length; ++i) {
            strList[i] = strList[i].trim();
        }
        Collections.addAll(list, strList);
    }

    private String getFormattedData(NBTTagCompound compound) {
        String s = "\n";
        for (int i = 0; i < 4; ++i) {
            String text = compound.func_74779_i("Text" + (i + 1)).replaceFirst("\"", "");
            int lastPos = text.lastIndexOf("\"");
            s = s + (Object)((Object)Colors.WHITE) + "[" + (Object)((Object)Colors.GRAY) + text.substring(0, lastPos < 0 ? text.length() : lastPos) + (Object)((Object)Colors.WHITE) + "]\n";
        }
        return s;
    }

    private boolean isMoving(int itemDamage) {
        return (itemDamage & 7) == 7;
    }

    private ItemStack toggleMoving(ItemStack stack) {
        if (stack.func_77952_i() == 2) {
            stack.func_77964_b(7);
        } else if (this.isMoving(stack.func_77952_i())) {
            stack.func_77964_b(2);
        }
        return stack;
    }
}

