/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns;

import gory_moon.moarsigns.Config;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.client.interfaces.GuiHandler;
import gory_moon.moarsigns.integration.IntegrationHandler;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.items.NuggetRegistry;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.proxy.CommonProxy;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="moarsigns", name="MoarSigns", version="2.1.0", certificateFingerprint="5a57c7d1420cf4c58f53ea2a298ebef8215ede63", guiFactory="gory_moon.moarsigns.client.interfaces.config.GuiFactory", dependencies="after:BiomesOPlenty;after:Forestry;after:Nature;after:IC2;after:TConstruct;after:Railcraft;after:ThermalFoundation;after:factorization;after:basemetals;after:NotEnoughItems;after:Waila;after:MineTweaker3;", acceptedMinecraftVersions="[1.8.9]")
public class MoarSigns {
    private static final String LINK = "https://raw.githubusercontent.com/GoryMoon/MoarSigns/master/version.json";
    @Mod.Instance(value="moarsigns")
    public static MoarSigns instance;
    public Config config;
    @SidedProxy(clientSide="gory_moon.moarsigns.proxy.ClientProxy", serverSide="gory_moon.moarsigns.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    private static HashMap<String, ResourceLocation> textures;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Config(event.getSuggestedConfigurationFile()).loadConfig();
        MinecraftForge.EVENT_BUS.register((Object)this.config);
        FMLInterModComms.sendRuntimeMessage((Object)"moarsigns", (String)"VersionChecker", (String)"addVersionCheck", (String)LINK);
        PacketHandler.init();
        proxy.init();
        NuggetRegistry.init();
        Blocks.init();
        ModItems.init();
        proxy.postInit();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        if (FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"gory_moon.moarsigns.integration.waila.Provider.callbackRegister")) {
            logger.info("Loaded Waila Integration");
        }
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        new IntegrationHandler().setupSigns();
        ModItems.registerRecipes();
    }

    public ResourceLocation getResourceLocation(String s, boolean isMetal) {
        ResourceLocation location = textures.get(isMetal + s);
        if (location == null) {
            SignInfo info = SignRegistry.get(s);
            if (info == null) {
                return null;
            }
            location = new ResourceLocation(info.modId.toLowerCase(), "textures/signs/" + (isMetal ? "metal/" : "wood/") + s + ".png");
            textures.put(s, location);
        }
        return location;
    }

    static {
        logger = LogManager.getLogger((String)"MoarSigns");
        textures = new HashMap();
    }
}

