/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.interfaces.containers;

import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.MaterialRegistry;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.client.interfaces.containers.ContainerExchange;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.items.ItemSignToolbox;
import gory_moon.moarsigns.items.ModItems;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class InventoryExchange
implements IInventory {
    public ItemStack[] inventory = new ItemStack[28];
    public ContainerExchange container;

    public void clearInventory() {
        for (int i = 1; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }

    public void update() {
        ItemStack signStack = this.inventory[0];
        this.clearInventory();
        if (signStack == null) {
            this.container.onSlotChanged();
            return;
        }
        Item item = signStack.getItem();
        if (item == null) {
            return;
        }
        if (!(item instanceof ItemMoarSign)) {
            return;
        }
        ItemMoarSign cfr_ignored_0 = (ItemMoarSign)item;
        String texture = ItemMoarSign.getTextureFromNBTFull(signStack.getTagCompound());
        SignInfo signInfo = SignRegistry.get(texture);
        if (signInfo == null) {
            return;
        }
        HashSet<MaterialInfo> materials = MaterialRegistry.get(signInfo.material.materialName);
        if (materials == null || materials.size() < 1) {
            return;
        }
        ArrayList<SignInfo> signs = SignRegistry.getSignInfoFromMaterials(materials);
        if (signs == null || signs.size() < 1) {
            return;
        }
        for (int i = 0; i + 1 < 28 && i < signs.size(); ++i) {
            SignInfo info = signs.get(i);
            this.inventory[i + 1] = ModItems.sign.createMoarItemStack(info.material.path + info.itemName, info.isMetal);
        }
        this.container.onSlotChanged();
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int i) {
        return this.inventory[i];
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].stackSize <= amount) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            }
            ItemStack stack = this.inventory[slot].splitStack(amount);
            if (this.inventory[slot].stackSize == 0) {
                this.inventory[slot] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack removeStackFromSlot(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack == null) {
            return null;
        }
        this.inventory[slot] = null;
        return stack;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
    }

    public String getName() {
        return "Exchange Inventory";
    }

    public boolean hasCustomName() {
        return false;
    }

    public IChatComponent getDisplayName() {
        return this.hasCustomName() ? new ChatComponentText(this.getName()) : new ChatComponentTranslation(this.getName(), new Object[0]);
    }

    public int getInventoryStackLimit() {
        return 16;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return (stack == null || !(stack.getItem() instanceof ItemSignToolbox)) && i == this.inventory.length && stack != null && stack.getItem() instanceof ItemMoarSign;
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }
}

