package gory_moon.moarsigns.client.particle;

import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class EntityDiggingFXMoarSigns extends EntityDiggingFX {
    public EntityDiggingFXMoarSigns(World world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, BlockPos pos, IBlockState state) {
        super(world, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, state);

        TileEntityMoarSign tileEntity = (TileEntityMoarSign) world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.texture_name != null) {
            SignInfo info = SignRegistry.get(tileEntity.texture_name);

            if (info != null && info.material != null && info.material.material.func_77973_b() != null) {
                Block Mblock = Block.func_149634_a(info.isMetal ? info.material.materialBlock.func_77973_b() : info.material.material.func_77973_b());

                if (Mblock != null && !Mblock.func_149739_a().equals("tile.air") && !Mblock.func_149739_a().equals("tile.ForgeFiller")) {
                    IBlockState state1 = ((ItemBlock)(info.isMetal ? info.material.materialBlock.func_77973_b(): info.material.material.func_77973_b())).field_150939_a.func_176203_a(info.isMetal ? info.material.materialBlock.func_77952_i(): info.material.material.func_77952_i());
                    func_180435_a(Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state1));
                } else {
                    Item item = info.material.material.func_77973_b();
                    if (item != null) {
                        func_180435_a(Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178087_a(item, info.material.material.func_77952_i()));
                    } else {
                        IBlockState state1 = ((info.isMetal ? Blocks.field_150339_S: Blocks.field_150344_f)).func_176203_a(0);
                        func_180435_a(Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state1));
                    }
                }
            }
        }
    }
}
