/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.renderers;

import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.client.models.ModelMoarSign;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Utils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MoarSignRenderer
extends TileEntitySpecialRenderer<TileEntityMoarSign> {
    private ModelMoarSign modelMoarSign;
    private ResourceLocation tempTexture = new ResourceLocation("textures/entity/sign.png");

    public MoarSignRenderer() {
        this.modelMoarSign = new ModelMoarSign();
    }

    public void renderTileEntityAt(TileEntityMoarSign te, double x, double y, double z, float partialTicks, int destroyStage) {
        float f1;
        ResourceLocation texture = te.getResourceLocation();
        Block block = te.getBlockType();
        GlStateManager.pushMatrix();
        float f = 0.6666667f;
        if (!(te.showInGui || block != Blocks.signStandingWood && block != Blocks.signStandingMetal)) {
            GlStateManager.translate((float)((float)x + 0.5f), (float)((float)y + 0.75f * f), (float)((float)z + 0.5f));
            float f2 = (float)(te.getBlockMetadata() * 360) / 16.0f;
            GlStateManager.rotate((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelMoarSign.stick.showModel = true;
        } else {
            int i = te.getBlockMetadata();
            int side = !te.showInGui ? i & 7 : 2;
            f1 = 0.0f;
            boolean flatSign = !te.showInGui && (i & 8) >> 3 == 1;
            boolean groundSign = false;
            if (flatSign) {
                int rotation;
                boolean bl = groundSign = (i & 1) == 1;
                if (groundSign) {
                    rotation = (i & 6) >> 1;
                    f1 = 0.0f;
                    if (rotation == 1) {
                        f1 = 90.0f;
                    } else if (rotation == 2) {
                        f1 = 180.0f;
                    } else if (rotation == 3) {
                        f1 = -90.0f;
                    }
                } else {
                    rotation = (i & 6) >> 1;
                    f1 = 180.0f;
                    if (rotation == 1) {
                        f1 = -90.0f;
                    } else if (rotation == 2) {
                        f1 = 0.0f;
                    } else if (rotation == 3) {
                        f1 = 90.0f;
                    }
                }
            } else {
                if (side == 2) {
                    f1 = 180.0f;
                }
                if (side == 4) {
                    f1 = 90.0f;
                }
                if (side == 5) {
                    f1 = -90.0f;
                }
            }
            GlStateManager.translate((float)((float)x + 0.5f), (float)((float)y + 0.75f * f), (float)((float)z + 0.5f));
            GlStateManager.rotate((float)(-f1), (float)0.0f, (float)1.0f, (float)0.0f);
            if (flatSign && !groundSign) {
                GlStateManager.rotate((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (flatSign && groundSign) {
                GlStateManager.rotate((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.translate((float)0.0f, (float)-0.3125f, (float)-0.4375f);
            this.modelMoarSign.stick.showModel = false;
        }
        if (destroyStage >= 0) {
            this.bindTexture(DESTROY_STAGES[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scale((float)4.0f, (float)2.0f, (float)1.0f);
            GlStateManager.translate((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else if (texture != null) {
            this.bindTexture(texture);
        } else {
            this.bindTexture(this.tempTexture);
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.pushMatrix();
        GlStateManager.scale((float)f, (float)(-f), (float)(-f));
        this.modelMoarSign.render();
        GlStateManager.popMatrix();
        FontRenderer fontRenderer = this.getFontRenderer();
        int[] sizes = te.rowSizes;
        boolean[] rows = te.visibleRows;
        int[] offset = te.rowLocations;
        if (destroyStage < 0) {
            for (int row = 0; row < rows.length; ++row) {
                if (te.signText[row] == null || !rows[row]) continue;
                float size = sizes[row];
                GlStateManager.pushMatrix();
                f1 = 0.016666668f * f + size / 1000.0f;
                GlStateManager.translate((float)(size > 0.0f ? 0.01f : 0.0f), (float)(0.5f * f - 0.02f * size - (size < 2.0f ? 0.0f : (size < 7.0f ? 0.01f : (size < 11.0f ? 0.02f : (size < 16.0f ? 0.03f : (size < 20.0f ? 0.035f : 0.037f)))))), (float)(0.07f * f));
                GlStateManager.scale((float)f1, (float)(-f1), (float)f1);
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)(-1.0f * f1));
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.depthMask((boolean)false);
                IChatComponent ichatcomponent = te.signText[row];
                List list = GuiUtilRenderComponents.func_178908_a((IChatComponent)ichatcomponent, (int)90, (FontRenderer)fontRenderer, (boolean)false, (boolean)true);
                String s = list != null && list.size() > 0 ? ((IChatComponent)list.get(0)).getFormattedText() : "";
                int maxLength = Utils.getMaxLength((int)size) - Utils.toPixelWidth(fontRenderer, Utils.getStyleOffset(s, te.shadowRows[row]));
                s = fontRenderer.trimStringToWidth(s, Math.min(maxLength, fontRenderer.getStringWidth(s)));
                GlStateManager.disableLighting();
                fontRenderer.drawString(s, (float)(-fontRenderer.getStringWidth(s) / 2), (float)(-te.signText.length * 5 + offset[row] - 2), 0, te.shadowRows[row]);
                GlStateManager.enableLighting();
                GlStateManager.depthMask((boolean)true);
                GlStateManager.popMatrix();
            }
        }
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }
}

