/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.client.interfaces;

import gory_moon.moarsigns.client.interfaces.containers.ContainerDebug;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiDebug
extends GuiContainer {
    private static final ResourceLocation texture_item = new ResourceLocation("moarsigns", "textures/gui/debug_item.png");
    private static final ResourceLocation texture_world = new ResourceLocation("moarsigns", "textures/gui/debug_block.png");
    private boolean blockInWorld;
    private World world;
    private BlockPos pos;
    private Block block;
    private IInventory inventory;
    private Rectangle infoArea;
    private String[] signText = new String[4];

    public GuiDebug(InventoryPlayer inventory, int ID, World world, BlockPos pos, IInventory tempInv, TileEntityMoarSign te) {
        super((Container)new ContainerDebug(inventory, ID, tempInv));
        this.world = world;
        this.pos = pos;
        this.inventory = tempInv;
        boolean bl = this.blockInWorld = ID == 0;
        if (this.blockInWorld) {
            this.block = world.getBlockState(pos).getBlock();
            this.infoArea = new Rectangle(8, 10, 160, 20);
        } else {
            this.infoArea = new Rectangle(31, 10, 137, 19);
        }
        TileEntityMoarSign sign = (TileEntityMoarSign)world.getTileEntity(pos);
        if (sign != null && sign.signText != null) {
            for (int i = 0; i < sign.signText.length; ++i) {
                this.signText[i] = sign.signText[i] + "\u00a7r" + (Object)((Object)Colors.CYAN);
            }
        }
        this.xSize = 178;
        this.ySize = 116;
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.blockInWorld ? texture_world : texture_item);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        int meta = 0;
        String Un = "";
        int x = 0;
        int y1 = 0;
        int y2 = 0;
        if (this.blockInWorld) {
            if (this.block != null) {
                Un = this.block.getUnlocalizedName();
                x = 10;
                y1 = 12;
                y2 = 20;
            }
        } else if (this.inventory.getStackInSlot(0) != null) {
            x = 33;
            y1 = 12;
            y2 = 20;
            ItemStack stack = this.inventory.getStackInSlot(0);
            Un = stack.getUnlocalizedName();
            meta = stack.getItemDamage();
        }
        if (!Un.equals("")) {
            String un = Un;
            if (!this.blockInWorld && Un.length() >= 23) {
                un = Un.substring(0, 20) + "...";
            } else if (this.blockInWorld && Un.length() >= 15) {
                un = Un.substring(0, 13) + "...";
            }
            this.fontRendererObj.drawString("UN: " + un, x, y1, 0x404040);
            this.fontRendererObj.drawString("Meta: " + meta, x, y2, 0x404040);
            this.infoArea.drawString(this, par1, par2, (Object)((Object)Colors.YELLOW) + "Unlocalized Name: " + Un + "\n" + (Object)((Object)Colors.LIGHTBLUE) + "Meta: " + meta + "\n" + (Object)((Object)Colors.CYAN) + Arrays.toString(this.signText));
        }
    }

    public int getLeft() {
        return this.guiLeft;
    }

    public int getTop() {
        return this.guiTop;
    }

    public void drawHoverString(List<String> lst, int x, int y) {
        this.drawHoveringText(lst, x, y, this.fontRendererObj);
    }

    public class Rectangle {
        private int x;
        private int y;
        private int w;
        private int h;

        public Rectangle(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public boolean inRect(GuiDebug gui, int mouseX, int mouseY) {
            return this.x <= (mouseX -= gui.getLeft()) && mouseX <= this.x + this.w && this.y <= (mouseY -= gui.getTop()) && mouseY <= this.y + this.h;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void draw(GuiDebug gui, int srcX, int srcY) {
            gui.drawTexturedModalRect(gui.getLeft() + this.x, gui.getTop() + this.y, srcX, srcY, this.w, this.h);
        }

        public void drawString(GuiDebug gui, int mouseX, int mouseY, String str) {
            if (this.inRect(gui, mouseX, mouseY)) {
                gui.drawHoverString(Arrays.asList(str.split("\n")), mouseX - gui.getLeft(), mouseY - gui.getTop());
            }
        }
    }
}

