/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.MoarSignsCreativeTab;
import gory_moon.moarsigns.blocks.BlockMoarSign;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.lib.ToolBoxModes;
import gory_moon.moarsigns.network.PacketHandler;
import gory_moon.moarsigns.network.message.MessageSignOpenGui;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Colors;
import gory_moon.moarsigns.util.Localization;
import gory_moon.moarsigns.util.PlacedCoord;
import gory_moon.moarsigns.util.RotationHandler;
import gory_moon.moarsigns.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSignToolbox
extends Item {
    public static final String SIGN_MOVING_TAG = "SignMoving";
    public static final String NBT_UNLOCALIZED_NAME = "SignUnlocalizedName";
    private IIcon[] icons = new IIcon[ToolBoxModes.values().length];

    public ItemSignToolbox() {
        this.setUnlocalizedName("moarsigns.signtoolbox");
        this.setCreativeTab(MoarSignsCreativeTab.tabMS);
        this.setHasSubtypes(true);
        this.setMaxStackSize(1);
    }

    public boolean isDamageable() {
        return true;
    }

    public void registerIcons(IIconRegister register) {
        for (int i = 0; i < ToolBoxModes.values().length; ++i) {
            this.icons[i] = register.registerIcon("moarsigns:toolbox/" + ToolBoxModes.values()[i].toString().toLowerCase());
        }
    }

    public IIcon getIconFromDamage(int itemDamage) {
        if (itemDamage > 5 && !this.isMoving(itemDamage)) {
            return null;
        }
        int mode = this.isMoving(itemDamage) ? 2 : itemDamage;
        return this.icons[mode];
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition.MovingObjectType hit;
        if (!world.isRemote && (hit = FMLClientHandler.instance().getClient().objectMouseOver.typeOfHit) == MovingObjectPosition.MovingObjectType.MISS) {
            int mode;
            int n = mode = this.isMoving(stack.getItemDamage()) ? 2 : stack.getItemDamage();
            if (player.isSneaking() && !this.isMoving(stack.getItemDamage())) {
                return this.rotateModes(stack);
            }
            if (ToolBoxModes.values()[mode] == ToolBoxModes.EXCHANGE_MODE) {
                this.doExchange(world, 0, 0, 0, player);
            } else if (ToolBoxModes.values()[mode] == ToolBoxModes.PREVIEW_MODE) {
                this.doPreview(world, 0, 0, 0, player);
            }
        }
        return super.onItemRightClick(stack, world, player);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            int mode = this.isMoving(stack.getItemDamage()) ? 2 : stack.getItemDamage();
            switch (ToolBoxModes.values()[mode]) {
                case EDIT_MODE: {
                    this.doEdit(world, x, y, z, player);
                    break;
                }
                case ROTATE_MODE: {
                    this.doRotate(world, x, y, z);
                    break;
                }
                case MOVE_MODE: {
                    return this.doMove(world, x, y, z, stack, player, side, hitX, hitY, hitZ);
                }
                case COPY_MODE: {
                    this.doCopy(world, x, y, z, stack);
                    break;
                }
                case EXCHANGE_MODE: {
                    this.doExchange(world, x, y, z, player);
                    return true;
                }
                case PREVIEW_MODE: {
                    this.doPreview(world, x, y, z, player);
                    return true;
                }
            }
        }
        return false;
    }

    private void doRotate(World world, int x, int y, int z) {
        if (world.getBlock(x, y, z) instanceof BlockMoarSign) {
            RotationHandler.rotate((TileEntityMoarSign)world.getTileEntity(x, y, z));
        }
    }

    private void doEdit(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity entity;
        if (world.getBlock(x, y, z) instanceof BlockMoarSign && (entity = world.getTileEntity(x, y, z)) instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileEntity = (TileEntityMoarSign)entity;
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSignOpenGui(tileEntity, false), (EntityPlayerMP)player);
        }
    }

    private void doCopy(World world, int x, int y, int z, ItemStack stack) {
        TileEntity tileEntity;
        NBTTagCompound signInfo = stack.getTagCompound();
        if (GuiScreen.isCtrlKeyDown()) {
            TileEntity tileEntity2 = world.getTileEntity(x, y, z);
            if (tileEntity2 instanceof TileEntityMoarSign) {
                signInfo = new NBTTagCompound();
                tileEntity2.writeToNBT(signInfo);
                signInfo.removeTag("texture");
                signInfo.removeTag("isMetal");
                stack.setTagCompound(signInfo);
            }
        } else if (signInfo != null && (tileEntity = world.getTileEntity(x, y, z)) instanceof TileEntityMoarSign) {
            tileEntity.readFromNBT(signInfo);
            tileEntity.xCoord = x;
            tileEntity.yCoord = y;
            tileEntity.zCoord = z;
            world.markBlockForUpdate(x, y, z);
        }
    }

    private boolean doMove(World world, int x, int y, int z, ItemStack stack, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        boolean val = true;
        NBTTagCompound signInfo = stack.getTagCompound();
        if (!this.isMoving(stack.getItemDamage())) {
            TileEntity tileEntity = world.getTileEntity(x, y, z);
            if (tileEntity instanceof TileEntityMoarSign) {
                TileEntityMoarSign tileEntityMoarSign = (TileEntityMoarSign)tileEntity;
                signInfo = new NBTTagCompound();
                tileEntity.writeToNBT(signInfo);
                ItemStack signStack = ModItems.sign.createMoarItemStack(tileEntityMoarSign.texture_name, tileEntityMoarSign.isMetal);
                String unlocalizedName = signStack.getUnlocalizedName() + ".name";
                signInfo.setString(NBT_UNLOCALIZED_NAME, unlocalizedName);
                stack = this.toggleMoving(stack);
                tileEntityMoarSign.removeNoDrop = true;
                world.setBlock(x, y, z, Blocks.air);
            }
        } else {
            String texture = signInfo.getString("texture");
            boolean isMetal = signInfo.getBoolean("isMetal");
            ItemStack moarSignsStack = ModItems.sign.createMoarItemStack(texture, isMetal);
            moarSignsStack.getTagCompound().setBoolean(SIGN_MOVING_TAG, true);
            val = ModItems.sign.onItemUse(moarSignsStack, player, world, x, y, z, side, hitX, hitY, hitZ);
            if (val) {
                PlacedCoord coord = new PlacedCoord(x, y, z, side);
                coord = Utils.calculatePlaceSideCoord(coord);
                x = coord.x;
                y = coord.y;
                z = coord.z;
                signInfo.removeTag(NBT_UNLOCALIZED_NAME);
                TileEntityMoarSign entityMoarSign = (TileEntityMoarSign)world.getTileEntity(x, y, z);
                entityMoarSign.readFromNBT(signInfo);
                entityMoarSign.xCoord = x;
                entityMoarSign.yCoord = y;
                entityMoarSign.zCoord = z;
                world.markBlockForUpdate(x, y, z);
                signInfo = null;
                stack = this.toggleMoving(stack);
            }
        }
        stack.setTagCompound(signInfo);
        return !val;
    }

    private void doExchange(World world, int x, int y, int z, EntityPlayer player) {
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MoarSigns.instance, (int)2, (World)world, (int)x, (int)y, (int)z);
    }

    private void doPreview(World world, int x, int y, int z, EntityPlayer player) {
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MoarSigns.instance, (int)3, (World)world, (int)x, (int)y, (int)z);
    }

    private ItemStack rotateModes(ItemStack stack) {
        int mode = stack.getItemDamage();
        mode = mode + 1 >= 6 ? 0 : mode + 1;
        stack.setItemDamage(mode);
        return stack;
    }

    public String getUnlocalizedName(ItemStack stack) {
        if (stack.getItemDamage() > 5 && !this.isMoving(stack.getItemDamage())) {
            stack.setItemDamage(0);
        }
        int mode = this.isMoving(stack.getItemDamage()) ? 2 : stack.getItemDamage();
        return super.getUnlocalizedName(stack) + "." + ToolBoxModes.values()[mode].toString();
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean extraInfo) {
        GameSettings gameSettings = FMLClientHandler.instance().getClient().gameSettings;
        String str = (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.CHANGE.translate((Object)((Object)Colors.LIGHTGRAY) + "[" + GameSettings.getKeyDisplayString((int)gameSettings.keyBindSneak.getKeyCode()) + "]" + Colors.GRAY.toString());
        int mode = this.isMoving(stack.getItemDamage()) ? 2 : stack.getItemDamage();
        switch (ToolBoxModes.values()[mode]) {
            case COPY_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.COPY.translate(Colors.LIGHTGRAY.toString() + "[", Minecraft.isRunningOnMac ? "0" : "1", "]" + Colors.GRAY.toString(), "\n" + Colors.LIGHTGRAY.toString() + "[");
                if (stack.getTagCompound() == null) break;
                str = str + "\n" + (Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGNTOOLBOX.CURRENT_TEXT.translate(new String[0]) + this.getFormattedData(stack.getTagCompound());
                break;
            }
            case MOVE_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.MOVE.translate(Colors.LIGHTGRAY.toString() + "[", "]" + Colors.GRAY.toString(), "\n" + Colors.GRAY.toString(), "\n" + Colors.RED.toString());
                if (stack.getTagCompound() == null) break;
                String unlocName = stack.getTagCompound().getString(NBT_UNLOCALIZED_NAME);
                String signName = StatCollector.translateToLocal((String)unlocName);
                str = str + "\n" + (Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGNTOOLBOX.CURRENT_SIGN.translate(new String[0]) + " " + (Object)((Object)Colors.WHITE) + signName + "\n" + (Object)((Object)Colors.LIGHTGRAY) + Localization.ITEM.SIGNTOOLBOX.CURRENT_TEXT.translate(new String[0]) + this.getFormattedData(stack.getTagCompound());
                break;
            }
            case EXCHANGE_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.EXCHANGE.translate("\n" + Colors.GRAY.toString());
                break;
            }
            case PREVIEW_MODE: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.PREVIEW.translate("\n" + Colors.GRAY.toString());
                break;
            }
            default: {
                str = str + "\n" + (Object)((Object)Colors.GRAY) + Localization.ITEM.SIGNTOOLBOX.values()[stack.getItemDamage() + 1].translate(Colors.LIGHTGRAY.toString(), Colors.GRAY.toString());
            }
        }
        String[] strList = str.split("\n");
        for (int i = 0; i < strList.length; ++i) {
            strList[i] = strList[i].trim();
        }
        Collections.addAll(list, strList);
    }

    private String getFormattedData(NBTTagCompound compound) {
        String s = "\n";
        for (int i = 0; i < 4; ++i) {
            s = s + (Object)((Object)Colors.WHITE) + "[" + (Object)((Object)Colors.GRAY) + compound.getString("Text" + (i + 1)) + (Object)((Object)Colors.WHITE) + "]\n";
        }
        return s;
    }

    private boolean isMoving(int itemDamage) {
        return (itemDamage & 7) == 7;
    }

    private ItemStack toggleMoving(ItemStack stack) {
        if (stack.getItemDamage() == 2) {
            stack.setItemDamage(7);
        } else if (this.isMoving(stack.getItemDamage())) {
            stack.setItemDamage(2);
        }
        return stack;
    }
}

