/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.util;

import net.minecraft.util.StatCollector;

public final class Localization {
    private static String translateString(String key, String ... vars) {
        String result = StatCollector.func_74838_a((String)key);
        for (int i = 0; i < vars.length; ++i) {
            String optionCheck = "[%" + (i + 1) + "->";
            int pos = result.indexOf(optionCheck);
            if (pos != -1) {
                int pickedOption;
                int endPos = result.indexOf("]");
                if (endPos == -1) continue;
                String[] options = result.substring(pos + optionCheck.length(), endPos).split("\\|");
                int n = pickedOption = vars[i].equals("1") ? 1 : 0;
                if (options.length <= pickedOption) continue;
                String opt = options[pickedOption];
                result = result.substring(0, pos) + opt + result.substring(endPos + 1);
                --i;
                continue;
            }
            result = result.replace("[%" + (i + 1) + "]", vars[i]);
        }
        return result;
    }

    public static class GUI {

        public static enum TEXTSTYLES {
            RANDOM,
            BOLD,
            STRIKETHROUGH,
            UNDERLINE,
            ITALIC,
            RESET;

            private String key = this.toString().toLowerCase();

            public String translate() {
                return Localization.translateString("gui.moarsigns:textstyle." + this.key, new String[]{""});
            }
        }

        public static enum COLORS {
            BLACK,
            BLUE,
            GREEN,
            CYAN,
            RED,
            PURPLE,
            ORANGE,
            LIGHTGRAY,
            GRAY,
            LIGHTBLUE,
            LIME,
            TURQUISE,
            PINK,
            MAGNETA,
            YELLOW,
            WHITE;

            private String key = this.toString().toLowerCase();

            public String translate() {
                return Localization.translateString("gui.moarsigns:color." + this.key, new String[]{""});
            }
        }

        public static enum BUTTONS {
            CUT,
            COPY,
            PASTE,
            CUTSIGN,
            COPYSIGN,
            PASTESIGN,
            RESET,
            COLORSELECTOR,
            TEXTSTYLE,
            LOCK,
            TEXT_SIZE,
            TEXT_POSITION,
            TEXT_SHOWHIDE,
            TEXT_SHADOW;

            private String key = this.toString().toLowerCase().replaceAll("_", ".");

            public String translateTitles(String ... vars) {
                return Localization.translateString("gui.moarsigns:button.title." + this.key, vars);
            }

            public String translateDescriptions(String ... vars) {
                return Localization.translateString("gui.moarsigns:button.description." + this.key, vars);
            }
        }
    }

    public static class ITEM {

        public static enum SIGNTOOLBOX {
            CHANGE,
            EDIT,
            ROTATE,
            COPY,
            MOVE;

            private String key = this.toString().toLowerCase();

            public String translate(String ... vars) {
                return Localization.translateString("item.moarsign.description:signtoolbox." + this.key, vars);
            }
        }
    }
}

