/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.client.particle.EntityDiggingFXMoarSigns;
import gory_moon.moarsigns.items.ModItems;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMoarSign
extends BlockContainer {
    public boolean isFreestanding;

    protected BlockMoarSign(Material material, boolean freeStand) {
        super(material);
        this.func_149663_c("moarsign.sign");
        this.isFreestanding = freeStand;
        float f = 0.25f;
        float f1 = 1.0f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        Boolean s = !((TileEntityMoarSign)world.func_147438_o((int)x, (int)y, (int)z)).isMetal;
        return s != false ? Blocks.field_150344_f.func_149673_e(world, x, y, z, side) : Blocks.field_150339_S.func_149673_e(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return Blocks.field_150344_f.func_149691_a(par1, par2);
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World par1World, int par2, int par3, int par4) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_149633_g(par1World, par2, par3, par4);
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity instanceof TileEntityMoarSign) {
            TileEntityMoarSign sign = (TileEntityMoarSign)entity;
            SignInfo info = SignRegistry.get(sign.texture_name);
            if (info != null && info.property != null) {
                info.property.randomDisplayTick(world, x, y, z, random);
            }
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityMoarSign) {
            TileEntityMoarSign sign = (TileEntityMoarSign)tileEntity;
            SignInfo info = SignRegistry.get(sign.texture_name);
            if (info != null && info.property != null) {
                info.property.onEntityCollidedWithBlock(world, x, y, z, entity);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityMoarSign) {
            TileEntityMoarSign sign = (TileEntityMoarSign)tileEntity;
            SignInfo info = SignRegistry.get(sign.texture_name);
            if (info != null && info.property != null) {
                return info.property.onRightClick(world, x, y, z, player, side, hitX, hitY, hitZ);
            }
        }
        return false;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if (!this.isFreestanding) {
            boolean flatSign;
            int l = world.func_72805_g(x, y, z);
            float f = 0.28125f;
            float f1 = 0.78125f;
            float f2 = 0.0f;
            float f3 = 1.0f;
            float f4 = 0.125f;
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            int side = l & 7;
            boolean bl = flatSign = (l & 8) >> 3 == 1;
            if (flatSign) {
                boolean groundSign;
                boolean bl2 = groundSign = (l & 1) == 1;
                if (groundSign) {
                    int rotation = (l & 6) >> 1;
                    this.func_149676_a(f2, f2, f - 0.01f, f3, f4, f1 - 0.01f);
                    if (rotation == 1) {
                        this.func_149676_a(f - 0.05f, f2, f2, f1 - 0.05f, f4, f3);
                    } else if (rotation == 2) {
                        this.func_149676_a(f2, f2, f - 0.05f, f3, f4, f1 - 0.05f);
                    } else if (rotation == 3) {
                        this.func_149676_a(f - 0.01f, f2, f2, f1 - 0.01f, f4, f3);
                    }
                } else {
                    int rotation = (l & 6) >> 1;
                    this.func_149676_a(f2, f3 - f4, f - 0.05f, f3, f3, f1 - 0.05f);
                    if (rotation == 1) {
                        this.func_149676_a(f - 0.01f, f3 - f4, f2, f1 - 0.01f, f3, f3);
                    } else if (rotation == 2) {
                        this.func_149676_a(f2, f3 - f4, f - 0.01f, f3, f3, f1 - 0.01f);
                    } else if (rotation == 3) {
                        this.func_149676_a(f - 0.05f, f3 - f4, f2, f1 - 0.05f, f3, f3);
                    }
                }
            } else if (side == 2) {
                this.func_149676_a(f2, f - 0.01f, f3 - f4, f3, f1 - 0.01f, f3);
            } else if (side == 3) {
                this.func_149676_a(f2, f - 0.01f, f2, f3, f1 - 0.01f, f4);
            } else if (side == 4) {
                this.func_149676_a(f3 - f4, f - 0.01f, f2, f3, f1 - 0.01f, f3);
            } else if (side == 5) {
                this.func_149676_a(f2, f - 0.01f, f2, f4, f1 - 0.01f, f3);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        int b0 = 4;
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    effectRenderer.func_78873_a((EntityFX)new EntityDiggingFXMoarSigns(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, x, y, z, (Block)this, meta, 3).func_70596_a(x, y, z));
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        int side = target.field_72310_e;
        Block block = worldObj.func_147439_a(x, y, z);
        if (block != null) {
            float f = 0.1f;
            double d0 = (double)x + worldObj.field_73012_v.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
            double d1 = (double)y + worldObj.field_73012_v.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
            double d2 = (double)z + worldObj.field_73012_v.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
            if (side == 0) {
                d1 = (double)y + block.func_149665_z() - (double)f;
            }
            if (side == 1) {
                d1 = (double)y + block.func_149669_A() + (double)f;
            }
            if (side == 2) {
                d2 = (double)z + block.func_149706_B() - (double)f;
            }
            if (side == 3) {
                d2 = (double)z + block.func_149693_C() + (double)f;
            }
            if (side == 4) {
                d0 = (double)x + block.func_149704_x() - (double)f;
            }
            if (side == 5) {
                d0 = (double)x + block.func_149753_y() + (double)f;
            }
            effectRenderer.func_78873_a(new EntityDiggingFXMoarSigns(worldObj, d0, d1, d2, 0.0, 0.0, 0.0, x, y, z, block, worldObj.func_72805_g(x, y, z), side).func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f));
        }
        return true;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149655_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityMoarSign();
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        boolean flag = false;
        if (this.isFreestanding) {
            if (!world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a()) {
                flag = true;
            }
        } else {
            boolean flatSign;
            int i = world.func_72805_g(x, y, z);
            int i1 = i & 7;
            boolean bl = flatSign = (i & 8) >> 3 == 1;
            if (flatSign) {
                boolean groundSign;
                boolean bl2 = groundSign = (i & 1) == 1;
                flag = groundSign ? !world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a() : !world.func_147439_a(x, y + 1, z).func_149688_o().func_76220_a();
            } else {
                boolean bl3 = flag = i1 != 2 || !world.func_147439_a(x, y, z + 1).func_149688_o().func_76220_a();
                if (i1 == 2 && world.func_147439_a(x, y, z + 1).func_149688_o().func_76220_a()) {
                    flag = false;
                }
                if (i1 == 3 && world.func_147439_a(x, y, z - 1).func_149688_o().func_76220_a()) {
                    flag = false;
                }
                if (i1 == 4 && world.func_147439_a(x + 1, y, z).func_149688_o().func_76220_a()) {
                    flag = false;
                }
                if (i1 == 5 && world.func_147439_a(x - 1, y, z).func_149688_o().func_76220_a()) {
                    flag = false;
                }
            }
        }
        if (flag) {
            world.func_147468_f(x, y, z);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityMoarSign tileEntity = (TileEntityMoarSign)world.func_147438_o(x, y, z);
        String s = tileEntity.texture_name;
        s = s != null ? s : "null";
        return ModItems.sign.createMoarItemStack(s, tileEntity.isMetal);
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldMeta) {
        this.func_149697_b(world, x, y, z, oldMeta, 0);
        super.func_149749_a(world, x, y, z, oldBlock, oldMeta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity instanceof TileEntityMoarSign) {
            TileEntityMoarSign tileEntity = (TileEntityMoarSign)entity;
            if (tileEntity.isRemovedByPlayerAndCreative) {
                return ret;
            }
            ret.add(ModItems.sign.createMoarItemStack(tileEntity.texture_name, tileEntity.isMetal));
        }
        return ret;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity instanceof TileEntityMoarSign) {
            ((TileEntityMoarSign)entity).isRemovedByPlayerAndCreative = player.field_71075_bZ.field_75098_d;
        }
        return super.removedByPlayer(world, player, x, y, z, false);
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z, int meta) {
        boolean flatSign = (meta & 8) >> 3 == 1;
        int side = flatSign ? meta & 1 : meta & 7;
        switch (side) {
            case 0: {
                ++y;
                break;
            }
            case 1: {
                --y;
                break;
            }
            case 2: {
                ++z;
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                ++x;
                break;
            }
            case 5: {
                --x;
            }
        }
        return !super.func_149742_c(world, x, y, z) && world.func_147439_a(x, y, z).func_149688_o().func_76220_a();
    }
}

