package gory_moon.moarsigns.items;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.lib.Constants;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;

public class ItemDebug extends Item {

    public ItemDebug() {
        setRegistryName(Constants.DEBUG_ITEM_KEY);
        func_77655_b("moarsigns.debug");
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {

            RayTraceResult movingobjectposition = this.func_77621_a(world, player, true);

            if (movingobjectposition == null || movingobjectposition.field_72313_a == RayTraceResult.Type.MISS) {
                FMLNetworkHandler.openGui(player, MoarSigns.instance, 1, world, 0, 0, 0);
                return ActionResult.newResult(EnumActionResult.SUCCESS, itemStack);
            }
        }
        return ActionResult.newResult(EnumActionResult.PASS, itemStack);
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K)
            return EnumActionResult.PASS;

        FMLNetworkHandler.openGui(player, MoarSigns.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return EnumActionResult.SUCCESS;
    }

}
