package gory_moon.moarsigns.integration.vanilla;

import gory_moon.moarsigns.api.ISignRegistration;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.lib.Reference;
import gory_moon.moarsigns.util.IntegrationException;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

import javax.annotation.Nonnull;

public class MinecraftIntegration implements ISignRegistration {

    @Override
    public void registerSigns() throws IntegrationException {
        SignRegistry.register("oak_sign",       null, "oak",        "", false, ItemStack.field_190927_a, new ItemStack(Blocks.field_150344_f, 1, 0), Reference.MODID);
        SignRegistry.register("spruce_sign",    null, "spruce",     "", false, ItemStack.field_190927_a, new ItemStack(Blocks.field_150344_f, 1, 1), Reference.MODID);
        SignRegistry.register("birch_sign",     null, "birch",      "", false, ItemStack.field_190927_a, new ItemStack(Blocks.field_150344_f, 1, 2), Reference.MODID);
        SignRegistry.register("jungle_sign",    null, "jungle",     "", false, ItemStack.field_190927_a, new ItemStack(Blocks.field_150344_f, 1, 3), Reference.MODID);
        SignRegistry.register("acacia_sign",    null, "acacia",     "", false, ItemStack.field_190927_a, new ItemStack(Blocks.field_150344_f, 1, 4), Reference.MODID);
        SignRegistry.register("big_oak_sign",   null, "big_oak",    "", false, ItemStack.field_190927_a, new ItemStack(Blocks.field_150344_f, 1, 5), Reference.MODID);
        SignRegistry.register("iron_sign",      null, "iron",       "", true, new ItemStack(Items.field_191525_da, 1, 0), new ItemStack(Items.field_151042_j), new ItemStack(Blocks.field_150339_S), Reference.MODID).setMetal();
        SignRegistry.register("gold_sign",      null, "gold",       "", true, new ItemStack(Items.field_151074_bl, 1, 0), new ItemStack(Items.field_151043_k), new ItemStack(Blocks.field_150340_R), Reference.MODID).setMetal();
        SignRegistry.register("diamond_sign",   null, "diamond",    "", false, ItemStack.field_190927_a, new ItemStack(Items.field_151045_i), new ItemStack(Blocks.field_150484_ah), Reference.MODID).setMetal();
        SignRegistry.register("emerald_sign",   null, "emerald",    "", false, ItemStack.field_190927_a, new ItemStack(Items.field_151166_bC), new ItemStack(Blocks.field_150475_bE), Reference.MODID).setMetal();
        SignRegistry.register("lapis_sign",     null, "lapis",      "", false, ItemStack.field_190927_a, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), new ItemStack(Blocks.field_150368_y), Reference.MODID).setMetal();
        SignRegistry.register("quartz_sign",    null, "quartz",     "", false, ItemStack.field_190927_a, new ItemStack(Items.field_151128_bU), new ItemStack(Blocks.field_150371_ca), Reference.MODID).setMetal();
    }

    @Nonnull
    @Override
    public String getActivateTag() {
        return SignRegistry.ALWAYS_ACTIVE_TAG;
    }

    @Nonnull
    @Override
    public String getIntegrationName() {
        return "Minecraft";
    }

    @Override
    public String getModName() {
        return null;
    }
}
