package gory_moon.moarsigns.client.renderers;

import gory_moon.moarsigns.blocks.ModBlocks;
import gory_moon.moarsigns.client.models.ModelMoarSign;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;

import java.util.List;

public class MoarSignRenderer extends TileEntitySpecialRenderer<TileEntityMoarSign> {

    private ModelMoarSign modelMoarSign;
    private ResourceLocation tempTexture = new ResourceLocation("textures/entity/sign.png");

    public MoarSignRenderer() {
        this.modelMoarSign = new ModelMoarSign();
    }

    @Override
    public void func_192841_a(TileEntityMoarSign te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        ResourceLocation texture = te.getResourceLocation();

        Block block = te.func_145838_q();
        GlStateManager.func_179094_E();
        float f = 0.6666667F;
        float f1;

        if (!te.showInGui && (block == ModBlocks.SIGN_STANDING_WOOD || block == ModBlocks.SIGN_STANDING_METAL)) {
            GlStateManager.func_179109_b((float) x + 0.5F, (float) y + 0.75F * f, (float) z + 0.5F);
            float f2 = (float) (te.func_145832_p() * 360) / 16.0F;
            GlStateManager.func_179114_b(-f2, 0.0F, 1.0F, 0.0F);
            this.modelMoarSign.stick.field_78806_j = true;
        } else {
            int i = te.func_145832_p();

            int side = !te.showInGui ? i & 7 : 2;

            f1 = 0.0F;

            boolean flatSign = !te.showInGui && ((i & 8) >> 3) == 1;
            boolean groundSign = false;

            if (flatSign) {
                groundSign = (i & 1) == 1;

                if (groundSign) {
                    int rotation = (i & 6) >> 1;
                    f1 = 0F;

                    if (rotation == 1)
                        f1 = 90F;
                    else if (rotation == 2)
                        f1 = 180F;
                    else if (rotation == 3)
                        f1 = -90F;
                } else {
                    int rotation = (i & 6) >> 1;
                    f1 = 180F;

                    if (rotation == 1)
                        f1 = -90F;
                    else if (rotation == 2)
                        f1 = 0F;
                    else if (rotation == 3)
                        f1 = 90F;
                }
            } else {
                if (side == 2) {
                    f1 = 180.0F;
                }

                if (side == 4) {
                    f1 = 90.0F;
                }

                if (side == 5) {
                    f1 = -90.0F;
                }

            }

            GlStateManager.func_179109_b((float) x + 0.5F, (float) y + 0.75F * f, (float) z + 0.5F);
            GlStateManager.func_179114_b(-f1, 0.0F, 1.0F, 0.0F);
            if (flatSign && !groundSign)
                GlStateManager.func_179114_b(90.0F, 1.0F, 0.0F, 0.0F);
            if (flatSign && groundSign) {
                GlStateManager.func_179114_b(270.0F, 1.0F, 0.0F, 0.0F);
                GlStateManager.func_179114_b(180.0F, 0.0F, 0.0F, 1.0F);
            }
            GlStateManager.func_179109_b(0.0F, -0.3125F, -0.4375F);
            this.modelMoarSign.stick.field_78806_j = false;
        }

        if (destroyStage >= 0) {
            func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n(5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a(4.0F, 2.0F, 1.0F);
            GlStateManager.func_179109_b(0.0625F, 0.0625F, 0.0625F);
            GlStateManager.func_179128_n(5888);
        } else {
            if (texture != null)
                func_147499_a(texture);
            else
                func_147499_a(tempTexture);
        }

        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a(f, -f, -f);
        modelMoarSign.render();
        GlStateManager.func_179121_F();

        FontRenderer fontRenderer = func_147498_b();

        int[] sizes = te.rowSizes;
        boolean[] rows = te.visibleRows;
        int[] offset = te.rowLocations;

        if (destroyStage < 0) {
            for (int row = 0; row < rows.length; row++) {
                if (te.field_145915_a[row] != null) {
                    if (!rows[row])
                        continue;

                    float size = sizes[row];
                    GlStateManager.func_179094_E();
                    f1 = 0.016666668F * f + (size / 1000F);
                    GlStateManager.func_179109_b(size > 0 ? 0.01F : 0.0F, 0.5F * f - ((float) 0.02 * size) - (size < 2 ? 0 : size < 7 ? 0.01F : size < 11 ? 0.02F : size < 16 ? 0.03F : size < 20 ? 0.035F : 0.037F), 0.07F * f);
                    GlStateManager.func_179152_a(f1, -f1, f1);
                    GL11.glNormal3f(0.0F, 0.0F, -1.0F * f1);
                    GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
                    GlStateManager.func_179132_a(false);

                    ITextComponent ichatcomponent = te.field_145915_a[row];
                    List<ITextComponent> list = GuiUtilRenderComponents.func_178908_a(ichatcomponent, 90, fontRenderer, false, true);
                    String s = list != null && list.size() > 0 ? ((ITextComponent) list.get(0)).func_150254_d() : "";

                    int maxLength = Utils.getMaxLength((int) size) - Utils.toPixelWidth(fontRenderer, Utils.getStyleOffset(s, te.shadowRows[row]));
                    s = fontRenderer.func_78269_a(s, Math.min(maxLength, fontRenderer.func_78256_a(s)));

                    GlStateManager.func_179140_f();

                    fontRenderer.func_175065_a(s, -fontRenderer.func_78256_a(s) / 2, (-te.field_145915_a.length * 5) + offset[row] - 2, 0, te.shadowRows[row]);

                    GlStateManager.func_179145_e();

                    GlStateManager.func_179132_a(true);
                    GlStateManager.func_179121_F();
                }
            }
        }


        GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
        GlStateManager.func_179121_F();

        if (destroyStage >= 0) {
            GlStateManager.func_179128_n(5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n(5888);
        }
    }
}
