package gory_moon.moarsigns.client.interfaces.containers;

import gory_moon.moarsigns.client.interfaces.containers.slots.SlotInput;
import gory_moon.moarsigns.client.interfaces.containers.slots.SlotSelection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.*;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class ContainerExchange extends Container {

    public final InventoryExchange inventory;
    private InventoryPlayer playerInventory;
    private ItemStack itemToolBox;
    public boolean close;
    public int toolBoxSlot;

    public ContainerExchange(InventoryPlayer inventoryPlayer, InventoryExchange exchangeInv, EnumHand hand) {
        inventory = exchangeInv;
        playerInventory = inventoryPlayer;
        toolBoxSlot = hand == EnumHand.MAIN_HAND ? playerInventory.field_70461_c: playerInventory.func_70302_i_() - 1;
        exchangeInv.container = this;

        func_75146_a(new SlotInput(this, exchangeInv, 0, 22, 26));

        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 9; x++) {
                func_75146_a(new SlotSelection(this, exchangeInv, x + y * 9 + 1, 58 + 18 * x, 8 + y * 18));
            }
        }

        //Player inventory
        for (int x = 0; x < 9; x++) {
            func_75146_a(new Slot(inventoryPlayer, x, 40 + 18 * x, 138));
        }

        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 9; x++) {
                func_75146_a(new Slot(inventoryPlayer, x + y * 9 + 9, 40 + 18 * x, 80 + y * 18));
            }
        }

        itemToolBox = inventoryPlayer.func_70448_g();
        inventory.update();
    }

    public void onSlotChanged() {
        ItemStack stack = playerInventory.field_70462_a.get(toolBoxSlot);
        if (stack.func_190926_b() || !stack.func_77969_a(itemToolBox)) {
            close = true;
        }
    }

    @Override
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (clickTypeIn != ClickType.QUICK_CRAFT && slotId >= 0) {
            int clickedSlot = slotId - inventory.func_70302_i_();

            if (clickedSlot == toolBoxSlot || (clickTypeIn == ClickType.SWAP && dragType == toolBoxSlot)) {
                return ItemStack.field_190927_a;
            }

        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        inventory.clearInventory();
        if (!player.field_71071_by.func_70441_a(inventory.func_70301_a(0))) {
            InventoryHelper.func_180176_a(player.field_70170_p, player, inventory);
        }

        super.func_75134_a(player);
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return inventory.func_70300_a(player);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer entity, int slotIdx) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = this.field_75151_b.get(slotIdx);

        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack1 = slot.func_75211_c();
            itemStack = itemStack1.func_77946_l();

            if (slotIdx > 27) {
                if (this.field_75151_b.get(0).func_75214_a(itemStack1) && !this.func_75135_a(itemStack1, 0, 1, false))
                    return ItemStack.field_190927_a;
            } else {
                if (slotIdx < 28 && !itemStack1.func_190926_b()) {
                    ItemStack tempStack = entity.field_71071_by.func_70445_o();
                    entity.field_71071_by.func_70437_b(itemStack1.func_77946_l());
                    slot.func_190901_a(entity, itemStack1);
                    itemStack1 = entity.field_71071_by.func_70445_o();
                    entity.field_71071_by.func_70437_b(tempStack);
                }

                if (!this.func_75135_a(itemStack1, 28, 28 + 36, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            slot.func_75220_a(itemStack1, itemStack);

            if (itemStack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }

            if (itemStack1.func_190916_E() == itemStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }

            if (slotIdx > 28 || slotIdx == 0) {
                slot.func_190901_a(entity, itemStack1);
            }

            if (itemStack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
                return ItemStack.field_190927_a;
            } else {
                slot.func_75215_d(itemStack1);
                return itemStack1;
            }
        }
        return itemStack;
    }
}
