package gory_moon.moarsigns.api.ingredients;

import gory_moon.moarsigns.items.ModItems;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class MatchAllIngredient extends Ingredient {

    public ItemStack[] matchingStacksExploded;
    public IntList matchingStacksPacked;

    protected MatchAllIngredient() {
        super(new ItemStack(ModItems.SIGN, 1, OreDictionary.WILDCARD_VALUE));
    }

    protected MatchAllIngredient(ItemStack stack) {
        super(stack);
    }

    @Override
    public ItemStack[] func_193365_a() {
        if (matchingStacksExploded == null || matchingStacksExploded.length <= 0) {
            NonNullList<ItemStack> lst = NonNullList.func_191196_a();
            for (ItemStack s : this.field_193371_b) {
                if (s.func_77960_j() == net.minecraftforge.oredict.OreDictionary.WILDCARD_VALUE)
                    s.func_77973_b().func_150895_a(net.minecraft.creativetab.CreativeTabs.field_78027_g, lst);
                else
                    lst.add(s);
            }
            this.matchingStacksExploded = lst.toArray(new ItemStack[lst.size()]);
        }
        return this.matchingStacksExploded;
    }

    @Override
    public IntList func_194139_b() {
        if (this.matchingStacksPacked == null)
        {
            func_193365_a();
            this.matchingStacksPacked = new IntArrayList(this.matchingStacksExploded.length);

            for (ItemStack itemstack : this.matchingStacksExploded)
            {
                this.matchingStacksPacked.add(RecipeItemHelper.func_194113_b(itemstack));
            }

            this.matchingStacksPacked.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.matchingStacksPacked;
    }

    @Override
    protected void invalidate() {
        this.matchingStacksPacked = null;
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}
