/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.jei.exchange;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.integration.jei.exchange.ExchangeGridHelper;
import gory_moon.moarsigns.integration.jei.exchange.ExchangeRecipe;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class MoarSignsExchangeCategory
extends BlankRecipeCategory<ExchangeRecipe> {
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;
    @Nonnull
    private final ICraftingGridHelper craftingGridHelper;

    public MoarSignsExchangeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("moarsigns", "textures/gui/sign_exchange_nei.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 164, 118);
        this.localizedName = I18n.func_74838_a((String)"crafting.moarsigns.sign.exchange");
        this.craftingGridHelper = new ExchangeGridHelper(0, 1);
    }

    @Nonnull
    public String getUid() {
        return "moarsigns.exchange";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
    }

    public void drawAnimations(Minecraft minecraft) {
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull ExchangeRecipe recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 74, 12);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = 1 + x + y * 9;
                guiItemStacks.init(index, false, 2 + x * 18, 42 + y * 18);
            }
        }
        if (recipeWrapper != null) {
            ExchangeRecipe wrapper = recipeWrapper;
            this.craftingGridHelper.setInputStacks(guiItemStacks, wrapper.getInputs());
            this.craftingGridHelper.setOutput(guiItemStacks, wrapper.getOutputs());
        } else {
            MoarSigns.logger.error("RecipeWrapper is not a known crafting wrapper type: {}", new Object[]{recipeWrapper});
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, ExchangeRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 74, 12);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = 1 + x + y * 9;
                guiItemStacks.init(index, false, 2 + x * 18, 42 + y * 18);
            }
        }
        if (recipeWrapper != null) {
            this.craftingGridHelper.setInputStacks(guiItemStacks, ingredients.getInputs(ItemStack.class));
            this.craftingGridHelper.setOutput(guiItemStacks, ingredients.getOutputs(ItemStack.class));
        } else {
            MoarSigns.logger.error("RecipeWrapper is not a known crafting wrapper type: {}", new Object[]{recipeWrapper});
        }
    }
}

