package gory_moon.moarsigns.items;

import com.google.common.collect.Maps;
import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.api.*;
import gory_moon.moarsigns.lib.Reference;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

import java.util.*;

@GameRegistry.ObjectHolder(Reference.MODID)
public class ModItems {

    public static final ItemMoarSign SIGN = new ItemMoarSign();
    public static final ItemDebug DEBUG = new ItemDebug();
    public static final ItemNugget NUGGET = new ItemNugget();
    public static final ItemSignToolbox SIGN_TOOLBOX = new ItemSignToolbox();

    public static boolean replaceRecipes = true;

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        public static final Set<Item> ITEMS = new HashSet<>();

        /**
         * Register this mod's {@link Item}s.
         *
         * @param event The event
         */
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            NuggetRegistry.init();

            final Item[] items = {SIGN, DEBUG, NUGGET, SIGN_TOOLBOX};

            final IForgeRegistry<Item> registry = event.getRegistry();

            for (final Item item : items) {
                registry.register(item);
                ITEMS.add(item);
            }
        }
    }

    public static void registerRecipes() {
        RecipeSorter.register("moarsigns:shaped", ShapedMoarSignRecipe.class, RecipeSorter.Category.SHAPED, "after:minecraft:shaped before:minecraft:shapeless");
        RecipeSorter.register("moarsigns:shapeless", ShapelessMoarSignRecipe.class, RecipeSorter.Category.SHAPELESS, "after:minecraft:shapeless");
        removeRecipesWithResult(new ItemStack(Items.field_151155_ap, 3));

        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        SIGN.getSubItemStacks(list);

        ItemStack generalSign = null;
        for (ItemStack stack : list) {

            String texture = ItemMoarSign.getTextureFromNBTFull(stack.func_77978_p());
            boolean isMetal = stack.func_77952_i() == 1;
            stack.field_77994_a = 3;

            if (texture.equals("oak_sign")) {
                generalSign = stack;
                continue;
            }

            SignInfo s = SignRegistry.get(texture);
            List<MaterialInfo> materials = SignRegistry.getAlternativeMaterials(s);

            MaterialInfo material = s != null ? s.material : null;
            materials.add(0, material);
            for (MaterialInfo infos : materials) {
                ItemStack mat = infos.material;
                if (mat != null && mat.func_77973_b() != null && material != null) {
                    if (isMetal) {
                        handleMetalSign(mat, material, stack);
                        stack.field_77994_a = 9;
                    }
                    registerSignRecipe(mat, stack);
                }
            }
        }

        GameRegistry.addRecipe(new ShapedMoarSignRecipe(generalSign, true, true, "###", "###", " X ", '#', "plankWood", 'X', "stickWood"));
        GameRegistry.addRecipe(new ShapedMoarSignRecipe(SIGN_TOOLBOX, "rxr", "xsx", "rxr", 'x', "ingotIron", 's', ShapedMoarSignRecipe.MatchType.ALL, 'r', "dyeRed"));

        if (replaceRecipes) {
            replaceRecipes();
        }
    }

    private static void handleMetalSign(ItemStack mat, MaterialInfo material, ItemStack stack) {
        Container dummyContainer = new Container() {
            @Override
            public boolean func_75145_c(EntityPlayer entityplayer) {
                return true;
            }

            @Override
            public void func_75130_a(IInventory par1IInventory) {
            }
        };
        InventoryCrafting crafting = new InventoryCrafting(dummyContainer, 2, 2);

        mat.field_77994_a = 1;
        if (mat.func_77973_b() instanceof ItemBlock) {
            crafting.func_70299_a(0, mat);
            mat = CraftingManager.func_77594_a().func_82787_a(crafting, null);
        }
        ItemStack recNugget = null;
        if (mat != null) {
            mat.field_77994_a = 1;

            if (!material.gotNugget) {
                String unlocName = mat.func_77977_a();
                NuggetRegistry.NuggetInfo nuggetInfo = NuggetRegistry.getNuggetInfo(unlocName);
                if (nuggetInfo != null) {
                    nuggetInfo.needed = true;
                    recNugget = new ItemStack(NUGGET, 1, nuggetInfo.id);
                    OreDictionary.registerOre(nuggetInfo.oreName, recNugget.func_77946_l());

                    recNugget.field_77994_a = 9;
                    GameRegistry.addShapelessRecipe(recNugget.func_77946_l(), mat);
                    GameRegistry.addRecipe(new ShapedOreRecipe(mat, "xxx", "xxx", "xxx", 'x', nuggetInfo.oreName));
                }
            } else {
                crafting.func_70299_a(0, mat);
                recNugget = CraftingManager.func_77594_a().func_82787_a(crafting, null);
            }
        }

        if (recNugget != null && recNugget.func_77973_b() != null) {
            registerNuggetSign(recNugget, stack);
        }
    }

    private static void registerNuggetSign(ItemStack nuggetMaterial, ItemStack stack) {
        ItemStack result = stack.func_77946_l();
        result.field_77994_a = 1;
        nuggetMaterial.field_77994_a = 1;
        if (nuggetMaterial.func_77977_a().equals("item.moarsigns.diamond_nugget")) {
            GameRegistry.addRecipe(new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", 'X', "diamondNugget", '/', "stickWood"));
            GameRegistry.addRecipe(new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", 'X', "nuggetDiamond", '/', "stickWood"));
        } else if (nuggetMaterial.func_77977_a().equals("item.moarsigns.iron_nugget"))
            GameRegistry.addRecipe(new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", 'X', "nuggetIron", '/', "stickWood"));
        else if (nuggetMaterial.func_77977_a().equals("item.moarsigns.emerald_nugget"))
            GameRegistry.addRecipe(new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", 'X', "nuggetEmerald", '/', "stickWood"));
        else if (nuggetMaterial.func_77977_a().equals("item.moarsigns.lapis_nugget"))
            GameRegistry.addRecipe(new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", 'X', "nuggetLapis", '/', "stickWood"));
        else if (nuggetMaterial.func_77977_a().equals("item.moarsigns.quartz_nugget"))
            GameRegistry.addRecipe(new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", 'X', "nuggetQuartz", '/', "stickWood"));
        else
            GameRegistry.addRecipe(new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", 'X', nuggetMaterial, '/', "stickWood"));
    }

    private static void registerSignRecipe(ItemStack material, ItemStack result) {
        if (material.func_77977_a().equals(Items.field_151045_i.func_77658_a()))
            GameRegistry.addRecipe(new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", 'X', "gemDiamond", '/', "stickWood"));
        else if (material.func_77977_a().equals(Items.field_151166_bC.func_77658_a()))
            GameRegistry.addRecipe(new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", 'X', "gemEmerald", '/', "stickWood"));
        else if (material.func_77977_a().equals(Items.field_151042_j.func_77658_a()))
            GameRegistry.addRecipe(new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", 'X', "ingotIron", '/', "stickWood"));
        else
            GameRegistry.addRecipe(new ShapedMoarSignRecipe(result, true, true, "XXX", "XXX", " / ", 'X', material, '/', "stickWood"));
    }

    private static void replaceRecipes() {
        ArrayList recipes = (ArrayList) CraftingManager.func_77594_a().func_77592_b();
        ItemStack signStack = new ItemStack(Items.field_151155_ap);
        for (int scan = 0; scan < recipes.size(); scan++) {
            IRecipe tmpRecipe = (IRecipe) recipes.get(scan);
            List input = null;

            if (tmpRecipe instanceof ShapedRecipes) {
                input = Arrays.asList(((ShapedRecipes) tmpRecipe).field_77574_d);
            } else if (tmpRecipe instanceof ShapelessRecipes) {
                input = ((ShapelessRecipes) tmpRecipe).field_77579_b;
            } else if (tmpRecipe instanceof ShapedOreRecipe) {
                input = Arrays.asList(((ShapedOreRecipe) tmpRecipe).getInput());
            } else if (tmpRecipe instanceof ShapelessOreRecipe) {
                input = ((ShapelessOreRecipe) tmpRecipe).getInput();
            }

            if (input != null) {
                for (Object stack : input) {
                    if (stack instanceof ItemStack && OreDictionary.itemMatches((ItemStack) stack, signStack, false)) {
                        HashMap<ItemStack, Object> map = Maps.newHashMap();
                        map.put(signStack, ShapedMoarSignRecipe.MatchType.ALL);

                        IRecipe replacement = null;
                        if (tmpRecipe instanceof ShapedRecipes || tmpRecipe instanceof ShapedOreRecipe)
                            GameRegistry.addRecipe(replacement = new ShapedMoarSignRecipe(tmpRecipe, map));
                        if (tmpRecipe instanceof ShapelessRecipes || tmpRecipe instanceof ShapelessOreRecipe)
                            GameRegistry.addRecipe(replacement = new ShapelessMoarSignRecipe(tmpRecipe, map));

                        MoarSigns.logger.info("Replacing Recipe: " + tmpRecipe + " (containing " + stack + ") -> " + replacement);
                        recipes.remove(scan);
                    }
                }
            }
        }
    }


    private static void removeRecipesWithResult(ItemStack resultItem) {
        ArrayList recipes = (ArrayList) CraftingManager.func_77594_a().func_77592_b();

        for (int scan = 0; scan < recipes.size(); scan++) {
            IRecipe tmpRecipe = (IRecipe) recipes.get(scan);
            ItemStack recipeResult = tmpRecipe.func_77571_b();
            if (ItemStack.func_77989_b(resultItem, recipeResult)) {
                MoarSigns.logger.debug("Removing Recipe: " + recipes.get(scan) + " -> " + recipeResult);
                recipes.remove(scan);
            }
        }
    }

}
