package gory_moon.moarsigns.integration.nei;

import codechicken.nei.ItemList;
import codechicken.nei.api.stack.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import codechicken.nei.util.NEIServerUtils;
import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.ShapedMoarSignRecipe;
import gory_moon.moarsigns.api.ShapedMoarSignRecipe.MatchType;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.items.ItemMoarSign;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.text.translation.I18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import static gory_moon.moarsigns.integration.nei.NEIMoarSignConfig.moarSigns;

import codechicken.nei.recipe.ShapedRecipeHandler.CachedShapedRecipe;

public class NEIShapedMoarSignHandler extends ShapedRecipeHandler {
    @Override
    @SuppressWarnings("unchecked")
    public void loadCraftingRecipes(String outputId, Object... results) {
        if (outputId.equals("crafting") && getClass() == NEIShapedMoarSignHandler.class) {
            List<IRecipe> allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe iRecipe : allrecipes) {
                CachedMoarSignRecipe recipe = null;
                if (iRecipe instanceof ShapedMoarSignRecipe)
                    recipe = forgeShapedRecipe((ShapedMoarSignRecipe) iRecipe);

                if (recipe == null)
                    continue;

                recipe.computeVisuals();
                arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void loadCraftingRecipes(ItemStack result) {
        List<IRecipe> allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe iRecipe : allrecipes) {
            CachedMoarSignRecipe recipe = null;
            if (iRecipe instanceof ShapedMoarSignRecipe)
                recipe = forgeShapedRecipe((ShapedMoarSignRecipe) iRecipe);

            if (recipe == null || !NEIServerUtils.areStacksSameTypeCrafting(recipe.result.item, result))
                continue;

            if (((ShapedMoarSignRecipe) iRecipe).isNeiNBTDifferent() && !ItemStack.func_77970_a(recipe.result.item, result))
                continue;

            recipe.computeVisuals();
            arecipes.add(recipe);
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe iRecipe : (List<IRecipe>) CraftingManager.func_77594_a().func_77592_b()) {
            CachedMoarSignRecipe recipe = null;
            if (iRecipe instanceof ShapedMoarSignRecipe)
                recipe = forgeShapedRecipe((ShapedMoarSignRecipe) iRecipe);

            if (recipe == null || !recipe.contains(recipe.ingredients, ingredient))
                continue;

            recipe.computeVisuals();
            if (recipe.contains(recipe.ingredients, ingredient)) {
                recipe.setIngredientPermutation(recipe.ingredients, ingredient);
                arecipes.add(recipe);
            }

        }
    }

    @Override
    public TemplateRecipeHandler newInstance() {
        for (ItemStack stack : ItemList.items) {
            if (stack != null && stack.func_77973_b() instanceof ItemMoarSign) {
                moarSigns.add(stack);
            }
        }

        return super.newInstance();
    }

    private CachedMoarSignRecipe forgeShapedRecipe(ShapedMoarSignRecipe recipe) {
        int width;
        int height;

        try {
            width = recipe.width;
            height = recipe.height;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

        Object[] items = recipe.getInput();
        if (items == null)
            return null;
        for (Object item : items)
            if (item instanceof List && ((List<?>) item).isEmpty())
                return null;

        return new CachedMoarSignRecipe(width, height, items, recipe.func_77571_b());
    }

    @Override
    public String getRecipeName() {
        return I18n.func_74838_a("crafting.moarsigns.sign.shaped");
    }

    public class CachedMoarSignRecipe extends CachedShapedRecipe {

        public CachedMoarSignRecipe(int width, int height, Object[] items, ItemStack out) {
            super(width, height, items, out);
        }

        @Override
        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; x++) {
                for (int y = 0; y < height; y++) {
                    if (items[y * width + x] == null)
                        continue;
                    Object o = items[y * width + x];
                    if (o instanceof ItemStack) {
                        PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18, false);
                        stack.setMaxSize(1);
                        ingredients.add(stack);
                    } else if (o instanceof MatchType || o instanceof MaterialInfo) {
                        ArrayList<ItemStack> signs = new ArrayList<ItemStack>();
                        for (ItemStack stack : moarSigns) {
                            SignInfo info = ItemMoarSign.getInfo(stack.func_77978_p());

                            if (o instanceof MatchType) {
                                if (o == MatchType.ALL) {
                                    signs.add(stack);
                                } else if (o == MatchType.METAL && info.isMetal) {
                                    signs.add(stack);
                                } else if (o == MatchType.WOOD && !info.isMetal) {
                                    signs.add(stack);
                                }
                            } else if (((MaterialInfo) o).materialName.equals(info.material.materialName)) {
                                signs.add(stack);
                            }
                        }

                        PositionedStack stack = new PositionedStack(signs, 25 + x * 18, 6 + y * 18, false);
                        stack.setMaxSize(1);
                        ingredients.add(stack);
                    } else if (o instanceof List) {
                        PositionedStack stack = new PositionedStack(o, 25 + x * 18, 6 + y * 18, false);
                        stack.setMaxSize(1);
                        ingredients.add(stack);
                    }
                }
            }
        }

        @Override
        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            Iterator i$ = ingredients.iterator();

            PositionedStack stack;
            do {
                if (!i$.hasNext()) {
                    return false;
                }

                stack = (PositionedStack) i$.next();
            } while (!stackContains(stack, ingredient));

            return true;
        }

        private boolean stackContains(PositionedStack stack, ItemStack ingredient) {
            ItemStack[] arr$ = stack.items;

            for (ItemStack item : arr$) {
                if (ItemStack.func_77970_a(item, ingredient) && ingredient.func_77969_a(item)) {
                    return true;
                }
            }

            return false;
        }
    }
}
