/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network.message;

import gory_moon.moarsigns.client.interfaces.sign.GuiMoarSign;
import gory_moon.moarsigns.network.ClientMessageHandler;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSignOpenGui
implements IMessage {
    public BlockPos pos;
    public String texture;
    public boolean isMetal;
    public boolean isMoving;

    public MessageSignOpenGui() {
    }

    public MessageSignOpenGui(BlockPos pos, String texture, boolean isMetal) {
        this.pos = pos;
        this.texture = texture;
        this.isMetal = isMetal;
    }

    public MessageSignOpenGui(TileEntityMoarSign tileEntity, boolean isMoving) {
        this.pos = tileEntity.getPos();
        this.texture = tileEntity.texture_name;
        this.isMetal = tileEntity.isMetal;
        this.isMoving = isMoving;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        this.pos = packetBuf.readBlockPos();
        int textureLength = packetBuf.readInt();
        this.texture = new String(packetBuf.readBytes(textureLength).array(), Charset.forName("utf-8"));
        this.isMetal = packetBuf.readBoolean();
        this.isMoving = packetBuf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuf = new PacketBuffer(buf);
        packetBuf.writeBlockPos(this.pos);
        packetBuf.writeInt(this.texture.length());
        packetBuf.writeBytes(this.texture.getBytes(Charset.forName("utf-8")));
        packetBuf.writeBoolean(this.isMetal);
        packetBuf.writeBoolean(this.isMoving);
    }

    public static class Handler
    extends ClientMessageHandler<MessageSignOpenGui> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handle(MessageSignOpenGui message, MessageContext ctx) {
            Object tileEntity = FMLClientHandler.instance().getClient().theWorld.getTileEntity(message.pos);
            if (!(tileEntity instanceof TileEntityMoarSign)) {
                tileEntity = new TileEntityMoarSign();
                tileEntity.setWorldObj((World)FMLClientHandler.instance().getClient().theWorld);
                tileEntity.setPos(message.pos);
            }
            ((TileEntityMoarSign)((Object)tileEntity)).isMetal = message.isMetal;
            ((TileEntityMoarSign)((Object)tileEntity)).setResourceLocation(message.texture);
            tileEntity.markDirty();
            if (!message.isMoving) {
                FMLClientHandler.instance().getClient().displayGuiScreen((GuiScreen)new GuiMoarSign((TileEntityMoarSign)((Object)tileEntity)));
            }
        }
    }
}

