/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nonnull;

public class NuggetRegistry {
    private static HashMap<String, NuggetInfo> nuggets = Maps.newHashMap();
    private static HashMap<Integer, String> idMap = Maps.newHashMap();
    private static int i = 0;

    public static void init() {
        NuggetRegistry.registerNugget("diamond_nugget", "nuggetDiamond", "", "item.diamond", true);
        NuggetRegistry.registerNugget("iron_nugget", "nuggetIron", "", "item.ingotIron", true);
        NuggetRegistry.registerNugget("emerald_nugget", "nuggetEmerald", "", "item.emerald", true);
        NuggetRegistry.registerNugget("lapis_nugget", "nuggetLapis", "", "item.dyePowder.blue", true);
        NuggetRegistry.registerNugget("quartz_nugget", "nuggetQuartz", "", "item.netherquartz", true);
        NuggetRegistry.registerNugget("bronze_nugget_ic2", "nuggetBronze", "ic2/", "ic2.ingot.bronze");
        NuggetRegistry.registerNugget("copper_nugget_ic2", "nuggetCopper", "ic2/", "ic2.ingot.copper");
        NuggetRegistry.registerNugget("tin_nugget_ic2", "nuggetTin", "ic2/", "ic2.ingot.tin");
        NuggetRegistry.registerNugget("steel_nugget_ic2", "nuggetSteel", "ic2/", "ic2.ingot.steel");
        NuggetRegistry.registerNugget("lead_nugget_ic2", "nuggetLead", "ic2/", "ic2.ingot.lead");
        NuggetRegistry.registerNugget("tin_nugget_forestry", "nuggetTin", "for/", "item.for.ingotTin");
        NuggetRegistry.registerNugget("bronze_nugget_forestry", "nuggetBronze", "for/", "item.for.ingotBronze");
        NuggetRegistry.registerNugget("copper_nugget_forestry", "nuggetCopper", "for/", "item.for.ingotCopper");
        NuggetRegistry.registerNugget("silver_nugget_factorization", "nuggetSilver", "factorization/", "item.factorization:silver_ingot");
        NuggetRegistry.registerNugget("lead_nugget_factorization", "nuggetLead", "factorization/", "item.factorization:lead_ingot");
        NuggetRegistry.registerNugget("darkiron_nugget_factorization", "nuggetFzDarkIron", "factorization/", "item.factorization:dark_iron_ingot");
        NuggetRegistry.registerNugget("aluminium_nugget_techreborn", "nuggetAluminium", "techreborn/", "item.techreborn.ingot.aluminum");
        NuggetRegistry.registerNugget("brass_nugget_techreborn", "nuggetBrass", "techreborn/", "item.techreborn.ingot.brass");
        NuggetRegistry.registerNugget("chrome_nugget_techreborn", "nuggetChrome", "techreborn/", "item.techreborn.ingot.chrome");
        NuggetRegistry.registerNugget("copper_nugget_techreborn", "nuggetCopper", "techreborn/", "item.techreborn.ingot.copper");
        NuggetRegistry.registerNugget("electrum_nugget_techreborn", "nuggetElectrum", "techreborn/", "item.techreborn.ingot.electrum");
        NuggetRegistry.registerNugget("invar_nugget_techreborn", "nuggetInvar", "techreborn/", "item.techreborn.ingot.invar");
        NuggetRegistry.registerNugget("iridium_nugget_techreborn", "nuggetIridium", "techreborn/", "item.techreborn.ingot.iridium");
        NuggetRegistry.registerNugget("lead_nugget_techreborn", "nuggetLead", "techreborn/", "item.techreborn.ingot.lead");
        NuggetRegistry.registerNugget("nickel_nugget_techreborn", "nuggetNickel", "techreborn/", "item.techreborn.ingot.nickel");
        NuggetRegistry.registerNugget("platinum_nugget_techreborn", "nuggetPlatinum", "techreborn/", "item.techreborn.ingot.platinum");
        NuggetRegistry.registerNugget("silver_nugget_techreborn", "nuggetSilver", "techreborn/", "item.techreborn.ingot.silver");
        NuggetRegistry.registerNugget("steel_nugget_techreborn", "nuggetSteel", "techreborn/", "item.techreborn.ingot.steel");
        NuggetRegistry.registerNugget("tin_nugget_techreborn", "nuggetTin", "techreborn/", "item.techreborn.ingot.tin");
        NuggetRegistry.registerNugget("titanium_nugget_techreborn", "nuggetTitanium", "techreborn/", "item.techreborn.ingot.titanium");
        NuggetRegistry.registerNugget("tungsten_nugget_techreborn", "nuggetTungsten", "techreborn/", "item.techreborn.ingot.tungsten");
        NuggetRegistry.registerNugget("tungstensteel_nugget_techreborn", "nuggetTungstenSteel", "techreborn/", "item.techreborn.ingot.tungstensteel");
        NuggetRegistry.registerNugget("zinc_nugget_techreborn", "nuggetZinc", "techreborn/", "item.techreborn.ingot.zinc");
        NuggetRegistry.registerNugget("refinediron_nugget_techreborn", "nuggetRefinedIron", "techreborn/", "item.techreborn.ingot.refinedIron");
        NuggetRegistry.registerNugget("psimetal_nugget_psi", "nuggetPsiMetal", "psi/", "item.psi:psimetal");
        NuggetRegistry.registerNugget("psigem_nugget_psi", "nuggetPsiGem", "psi/", "item.psi:psigem");
        NuggetRegistry.registerNugget("ebonypsimetal_nugget_psi", "nuggetEbonyPsiMetal", "psi/", "item.psi:ebonyPsimetal");
        NuggetRegistry.registerNugget("ivorypsimetal_nugget_psi", "nuggetIvoryPsiMetal", "psi/", "item.psi:ivoryPsimetal");
        NuggetRegistry.registerNugget("yellorium_nugget_bigreactors", "nuggetYellorium", "bigreactors/", "item.bigreactors:ingotMetals.yellorium");
        NuggetRegistry.registerNugget("cyanite_nugget_bigreactors", "nuggetCyanite", "bigreactors/", "item.bigreactors:ingotMetals.cyanite");
        NuggetRegistry.registerNugget("graphite_nugget_bigreactors", "nuggetGraphite", "bigreactors/", "item.bigreactors:ingotMetals.graphite");
        NuggetRegistry.registerNugget("blutonium_nugget_bigreactors", "nuggetBlutonium", "bigreactors/", "item.bigreactors:ingotMetals.blutonium");
        NuggetRegistry.registerNugget("ludicrite_nugget_bigreactors", "nuggetLudicrite", "bigreactors/", "item.bigreactors:ingotMetals.ludicrite");
        NuggetRegistry.registerNugget("steel_nugget_bigreactors", "nuggetSteel", "bigreactors/", "item.bigreactors:ingotMetals.steel");
        NuggetRegistry.registerNugget("electricalsteel_nugget_enderio", "nuggetElectricalSteel", "enderio/", "enderio.electricalSteel");
        NuggetRegistry.registerNugget("energeticalloy_nugget_enderio", "nuggetEnergeticAlloy", "enderio/", "enderio.energeticAlloy");
        NuggetRegistry.registerNugget("redstonealloy_nugget_enderio", "nuggetRedstoneAlloy", "enderio/", "enderio.redstoneAlloy");
        NuggetRegistry.registerNugget("conductiveiron_nugget_enderio", "nuggetConductiveIron", "enderio/", "enderio.conductiveIron");
        NuggetRegistry.registerNugget("darksteel_nugget_enderio", "nuggetDarkSteel", "enderio/", "enderio.darkSteel");
        NuggetRegistry.registerNugget("soularium_nugget_enderio", "nuggetSoularium", "enderio/", "enderio.soularium");
    }

    public static void registerNugget(String unlocName, String oreName, String modId, String ingotName, boolean needed) {
        nuggets.put(ingotName, new NuggetInfo(i, unlocName, oreName, modId, ingotName, needed));
        idMap.put(i++, ingotName);
    }

    public static void registerNugget(String unlocName, String oreName, String modId, String ingotName) {
        NuggetRegistry.registerNugget(unlocName, oreName, modId, ingotName, false);
    }

    public static HashMap<String, NuggetInfo> getNuggets() {
        return nuggets;
    }

    public static String getUnlocName(int i) {
        return NuggetRegistry.nuggets.get((Object)NuggetRegistry.idMap.get((Object)Integer.valueOf((int)i))).unlocName;
    }

    public static NuggetInfo getNuggetInfo(String ingotName) {
        return nuggets.get(ingotName);
    }

    public static class NuggetInfo
    implements Comparable<NuggetInfo> {
        public String modId;
        public String unlocName;
        public String oreName;
        public String ingotName;
        public boolean needed;
        public int id;

        public NuggetInfo(int id, String unlocName, String oreName, String modId, String ingotName, boolean needed) {
            this.id = id;
            this.unlocName = unlocName;
            this.oreName = oreName;
            this.modId = modId;
            this.ingotName = ingotName;
            this.needed = needed;
        }

        @Override
        public int compareTo(@Nonnull NuggetInfo o) {
            return this.id < o.id ? -1 : (this.id > o.id ? 1 : 0);
        }
    }
}

