/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.integration.psi;

import gory_moon.moarsigns.api.ISignRegistration;
import gory_moon.moarsigns.api.SignRegistry;
import gory_moon.moarsigns.api.SignSpecialProperty;
import gory_moon.moarsigns.util.IntegrationException;
import gory_moon.moarsigns.util.Utils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PsiIntegration
implements ISignRegistration {
    private static final String PSI_TAG = "Psi";
    private static final String PATH = "psi/";
    private Item item = null;
    private Item itemBlock = null;

    @Override
    public void registerWoodenSigns(ArrayList<ItemStack> planks) throws IntegrationException {
    }

    @Override
    public void registerMetalSigns(ArrayList<ItemStack> metals) throws IntegrationException {
        for (ItemStack stack : metals) {
            if (stack.getUnlocalizedName().equals("item.psi:psimetal") && this.item == null) {
                this.item = stack.getItem();
            }
            if (stack.getUnlocalizedName().equals("tile.psi:psimetal_block") && this.itemBlock == null) {
                this.itemBlock = stack.getItem();
            }
            if (this.item == null || this.itemBlock == null) continue;
            break;
        }
        this.registerMetal("psimetal_sign", null, "psimetal", new ItemStack(this.item, 1, 1), new ItemStack(this.itemBlock, 1, 1));
        this.registerMetal("psigem_sign", null, "psigem", new ItemStack(this.item, 1, 2), new ItemStack(this.itemBlock, 1, 2));
        this.registerMetal("ebonypsimetal_sign", null, "ebonypsimetal", new ItemStack(this.item, 1, 3), new ItemStack(this.itemBlock, 1, 7));
        this.registerMetal("ivorypsimetal_sign", null, "ivotypsimetal", new ItemStack(this.item, 1, 4), new ItemStack(this.itemBlock, 1, 8));
    }

    private void registerMetal(String name, SignSpecialProperty property, String materialName, ItemStack material, ItemStack block) throws IntegrationException {
        SignRegistry.register(name, property, materialName, PATH, false, material, block, "moarsigns", PSI_TAG).setMetal();
    }

    @Override
    @Nonnull
    public String getActivateTag() {
        return PSI_TAG;
    }

    @Override
    @Nonnull
    public String getIntegrationName() {
        return Utils.getModName(PSI_TAG);
    }

    @Override
    @Nullable
    public String getModName() {
        return PSI_TAG;
    }
}

