/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.blocks;

import com.girafi.passthroughsigns.api.IPassable;
import gory_moon.moarsigns.blocks.BlockMoarSign;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(modid="passthroughsigns", iface="com.girafi.passthroughsigns.api.IPassable")
public class BlockMoarSignWall
extends BlockMoarSign
implements IPassable {
    public static final PropertyDirection FACING = PropertyDirection.create((String)"facing");
    protected static final AxisAlignedBB SIGN_EAST_AABB = new AxisAlignedBB(0.0, 0.28125, 0.0, 0.125, 0.78125, 1.0);
    protected static final AxisAlignedBB SIGN_WEST_AABB = new AxisAlignedBB(0.875, 0.28125, 0.0, 1.0, 0.78125, 1.0);
    protected static final AxisAlignedBB SIGN_SOUTH_AABB = new AxisAlignedBB(0.0, 0.28125, 0.0, 1.0, 0.78125, 0.125);
    protected static final AxisAlignedBB SIGN_NORTH_AABB = new AxisAlignedBB(0.0, 0.28125, 0.875, 1.0, 0.78125, 1.0);
    protected static final AxisAlignedBB SIGN_GROUND0_AABB = new AxisAlignedBB(0.0, 0.0, 0.27125, 1.0, 0.125, 0.77125);
    protected static final AxisAlignedBB SIGN_GROUND1_AABB = new AxisAlignedBB(0.23125, 0.0, 0.0, 0.73125, 0.125, 1.0);
    protected static final AxisAlignedBB SIGN_GROUND2_AABB = new AxisAlignedBB(0.0, 0.0, 0.23125, 1.0, 0.125, 0.73125);
    protected static final AxisAlignedBB SIGN_GROUND3_AABB = new AxisAlignedBB(0.27125, 0.0, 0.0, 0.77125, 0.125, 1.0);
    protected static final AxisAlignedBB SIGN_ROOF0_AABB = new AxisAlignedBB(0.0, 0.875, 0.23125, 1.0, 1.0, 0.73125);
    protected static final AxisAlignedBB SIGN_ROOF1_AABB = new AxisAlignedBB(0.27125, 0.875, 0.0, 0.77125, 1.0, 1.0);
    protected static final AxisAlignedBB SIGN_ROOF2_AABB = new AxisAlignedBB(0.0, 0.875, 0.27125, 1.0, 1.0, 0.77125);
    protected static final AxisAlignedBB SIGN_ROOF3_AABB = new AxisAlignedBB(0.23125, 0.875, 0.0, 0.23125, 1.0, 1.0);

    public BlockMoarSignWall(Material material, SoundType stepSound, float hardness, float resistance, String registryname, String harvestLevel, int level) {
        super(material, stepSound, hardness, resistance, registryname, harvestLevel, level);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)ROTATION, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION, FACING});
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int meta = this.getMetaFromState(state);
        boolean flatSign = (meta & 8) >> 3 == 1;
        int facing = flatSign ? meta & 1 : meta & 7;
        return state.withProperty((IProperty)FACING, (Comparable)EnumFacing.getFront((int)facing));
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)ROTATION);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean flatSign;
        int l = state.getBlock().getMetaFromState(state);
        EnumFacing side = EnumFacing.getFront((int)(l & 7));
        boolean bl = flatSign = (l & 8) >> 3 == 1;
        if (flatSign) {
            boolean groundSign = (l & 1) == 1;
            int rotation = (l & 6) >> 1;
            if (groundSign) {
                switch (rotation) {
                    case 1: {
                        return SIGN_GROUND1_AABB;
                    }
                    case 2: {
                        return SIGN_GROUND2_AABB;
                    }
                    case 3: {
                        return SIGN_GROUND3_AABB;
                    }
                }
                return SIGN_GROUND0_AABB;
            }
            switch (rotation) {
                case 1: {
                    return SIGN_ROOF1_AABB;
                }
                case 2: {
                    return SIGN_ROOF2_AABB;
                }
                case 3: {
                    return SIGN_ROOF3_AABB;
                }
            }
            return SIGN_ROOF0_AABB;
        }
        switch (side) {
            default: {
                return SIGN_NORTH_AABB;
            }
            case SOUTH: {
                return SIGN_SOUTH_AABB;
            }
            case WEST: {
                return SIGN_WEST_AABB;
            }
            case EAST: 
        }
        return SIGN_EAST_AABB;
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn) {
        boolean flag;
        boolean flatSign;
        int rotation = (Integer)world.getBlockState(pos).getValue((IProperty)ROTATION);
        EnumFacing facing = EnumFacing.getFront((int)(rotation & 7));
        boolean bl = flatSign = (rotation & 8) >> 3 == 1;
        if (flatSign) {
            boolean groundSign;
            boolean bl2 = groundSign = (rotation & 1) == 1;
            flag = groundSign ? !world.getBlockState(pos.down()).getMaterial().isSolid() : !world.getBlockState(pos.up()).getMaterial().isSolid();
        } else {
            boolean bl3 = flag = facing != EnumFacing.NORTH || !world.getBlockState(pos.south()).getMaterial().isSolid();
            if (world.getBlockState(pos.offset(facing.getOpposite())).getMaterial().isSolid()) {
                flag = false;
            }
        }
        if (flag) {
            world.setBlockToAir(pos);
        }
    }

    @Override
    @Optional.Method(modid="passthroughsigns")
    public boolean canBePassed(World world, BlockPos pos, IPassable.EnumPassableType type) {
        return type == IPassable.EnumPassableType.WALL_BLOCK;
    }
}

