/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.api;

import gory_moon.moarsigns.api.MaterialInfo;
import gory_moon.moarsigns.api.SignInfo;
import gory_moon.moarsigns.items.ItemMoarSign;
import gory_moon.moarsigns.util.IMoarSignsRecipe;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedMoarSignRecipe
implements IMoarSignsRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    public int width = 0;
    public int height = 0;
    private ItemStack output = null;
    private Object[] input = null;
    private boolean mirrored = true;
    private boolean neiNBTDifferent = false;

    public ShapedMoarSignRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapedMoarSignRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapedMoarSignRecipe(ItemStack result, Object ... recipe) {
        this.output = result.copy();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof Boolean) {
            this.neiNBTDifferent = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
                idx = 0;
            } else {
                idx = 2;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof MatchType) {
                itemMap.put(chr, (Object)((MatchType)((Object)in)));
            } else if (in instanceof MaterialInfo) {
                itemMap.put(chr, (MaterialInfo)in);
            } else if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).copy());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    public ShapedMoarSignRecipe(IRecipe recipe, Map<ItemStack, Object> replacements) {
        ShapedRecipes r;
        this.output = recipe.getRecipeOutput();
        Object[] items = null;
        if (recipe instanceof ShapedRecipes) {
            r = (ShapedRecipes)recipe;
            this.width = r.recipeWidth;
            this.height = r.recipeHeight;
            this.input = new Object[r.recipeItems.length];
            items = r.recipeItems;
        } else if (recipe instanceof ShapedOreRecipe) {
            r = (ShapedOreRecipe)recipe;
            this.width = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"width"});
            this.height = (Integer)ObfuscationReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)((ShapedOreRecipe)recipe), (String[])new String[]{"height"});
            this.input = new Object[r.getRecipeSize()];
            items = r.getInput();
        }
        if (items != null) {
            block0: for (int i = 0; i < this.input.length; ++i) {
                void ingred = items[i];
                this.input[i] = ingred;
                if (ingred == null || !(ingred instanceof ItemStack)) continue;
                for (Map.Entry<ItemStack, Object> replace : replacements.entrySet()) {
                    if (!OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)((ItemStack)ingred), (boolean)true)) continue;
                    if (replace.getValue() instanceof String) {
                        this.input[i] = OreDictionary.getOres((String)String.valueOf(replace.getValue()));
                        continue block0;
                    }
                    if (!(replace.getValue() instanceof MatchType) && !(replace.getValue() instanceof MaterialInfo)) continue block0;
                    this.input[i] = replace.getValue();
                    continue block0;
                }
            }
        }
    }

    public ItemStack getCraftingResult(InventoryCrafting var1) {
        return this.output.copy();
    }

    public int getRecipeSize() {
        return this.input.length;
    }

    public ItemStack getRecipeOutput() {
        return this.output;
    }

    public ItemStack[] getRemainingItems(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public boolean matches(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            block6: for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.getStackInRowAndColumn(x, y);
                if (target instanceof MatchType || target instanceof MaterialInfo) {
                    if (slot != null && slot.getItem() instanceof ItemMoarSign) {
                        SignInfo info = ItemMoarSign.getInfo(slot.getTagCompound());
                        if (target instanceof MatchType) {
                            switch ((MatchType)((Object)target)) {
                                case ALL: {
                                    continue block6;
                                }
                                case METAL: {
                                    if (info.isMetal) continue block6;
                                    return false;
                                }
                                case WOOD: {
                                    if (!info.isMetal) continue block6;
                                    return false;
                                }
                            }
                            continue;
                        }
                        if (info.material.materialName.equals(((MaterialInfo)target).materialName)) continue;
                        return false;
                    }
                    return false;
                }
                if (target instanceof ItemStack) {
                    if (slot != null && slot.getItem() instanceof ItemMoarSign && ((ItemStack)target).getItem() instanceof ItemMoarSign && !ItemStack.areItemStackTagsEqual((ItemStack)slot, (ItemStack)((ItemStack)target))) {
                        return false;
                    }
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if ((target != null || slot == null) && (target == null || slot != null)) continue;
                return false;
            }
        }
        return true;
    }

    public ShapedMoarSignRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    @Override
    public IMoarSignsRecipe setNEINBTDifferent(boolean nbtDiff) {
        this.neiNBTDifferent = nbtDiff;
        return this;
    }

    @Override
    public boolean isNeiNBTDifferent() {
        return this.neiNBTDifferent;
    }

    @Override
    public Object[] getInput() {
        return this.input;
    }

    public static enum MatchType {
        ALL,
        METAL,
        WOOD;


        public static MatchType getEnum(String value) {
            if (value.equals("ALL")) {
                return ALL;
            }
            if (value.equals("METAL")) {
                return METAL;
            }
            if (value.equals("WOOD")) {
                return WOOD;
            }
            return null;
        }
    }
}

