/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPHorseBase;
import se.gory_moon.horsepower.tileentity.TileEntityHandGrindstone;
import se.gory_moon.horsepower.util.Localization;

public class TileEntityGrindstone
extends TileEntityHPHorseBase {
    private int currentItemMillTime;
    private int totalItemMillTime;
    public ItemStack renderStack = ItemStack.field_190927_a;
    public Color grindColor;

    public TileEntityGrindstone() {
        super(3);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("millTime", this.currentItemMillTime);
        compound.func_74768_a("totalMillTime", this.totalItemMillTime);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.getStackInSlot(0).func_190916_E() > 0) {
            this.currentItemMillTime = compound.func_74762_e("millTime");
            this.totalItemMillTime = compound.func_74762_e("totalMillTime");
        } else {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = 1;
        }
    }

    @Override
    public void func_70296_d() {
        if (this.getStackInSlot(1).func_190926_b() && this.getStackInSlot(2).func_190926_b()) {
            BlockGrindstone.setState(false, this.field_145850_b, this.field_174879_c);
        }
        if (this.getStackInSlot(0).func_190926_b()) {
            this.currentItemMillTime = 0;
        }
        super.func_70296_d();
    }

    @Override
    public boolean validateArea() {
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x <= 1 && x >= -1 && z <= 1 && z >= -1) continue;
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, 0, z));
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, -1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            if (this.func_145831_w().func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean targetReached() {
        ++this.currentItemMillTime;
        if (this.currentItemMillTime >= this.totalItemMillTime) {
            this.currentItemMillTime = 0;
            this.totalItemMillTime = HPRecipes.instance().getGrindstoneTime(this.getStackInSlot(0), false);
            this.millItem();
            return true;
        }
        return false;
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getGrindstoneRecipe(this.getStackInSlot(0), false);
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getGrindstoneResult(this.getStackInSlot(0), false);
    }

    @Override
    public int getPositionOffset() {
        return -1;
    }

    private void millItem() {
        if (this.canWork()) {
            HPRecipeBase recipe = this.getRecipe();
            ItemStack result = recipe.getOutput();
            ItemStack secondary = recipe.getSecondary();
            ItemStack input = this.getStackInSlot(0);
            ItemStack output = this.getStackInSlot(1);
            ItemStack secondaryOutput = this.getStackInSlot(2);
            if (output.func_190926_b()) {
                this.setInventorySlotContents(1, result.func_77946_l());
            } else if (output.func_77969_a(result)) {
                output.func_190917_f(result.func_190916_E());
            }
            TileEntityHandGrindstone.processSecondaries(this.func_145831_w(), secondary, secondaryOutput, recipe, this);
            input.func_190918_g(1);
            BlockGrindstone.setState(true, this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = this.getStackInSlot(index);
        super.setInventorySlotContents(index, stack);
        if ((index == 1 || index == 2) && this.getStackInSlot(1).func_190926_b() && this.getStackInSlot(2).func_190926_b()) {
            BlockGrindstone.setState(false, this.field_145850_b, this.field_174879_c);
        }
        boolean bl = flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.totalItemMillTime = HPRecipes.instance().getGrindstoneTime(stack, false);
            this.currentItemMillTime = 0;
        }
        this.func_70296_d();
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index == 0 && HPRecipes.instance().hasGrindstoneRecipe(stack, false);
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.totalItemMillTime;
            }
            case 1: {
                return this.currentItemMillTime;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemMillTime = value;
                break;
            }
            case 1: {
                this.currentItemMillTime = value;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 2;
    }

    @Override
    public String getName() {
        return "container.mill";
    }

    @Override
    public int getOutputSlot() {
        return 2;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        if (this.valid) {
            return super.func_145748_c_();
        }
        return new TextComponentTranslation(Localization.INFO.GRINDSTONE_INVALID.key(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }
}

