/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.apache.commons.lang3.tuple.Pair;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HPEventHandler;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;

public class TileEntityManualChopper
extends TileEntityHPBase {
    private int currentItemChopAmount;
    private int totalItemChopAmount;
    private IItemHandler handlerSide = new RangedWrapper((IItemHandlerModifiable)new InvWrapper((IInventory)this.inventory), 0, 1);

    public TileEntityManualChopper() {
        super(2);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("chopTime", this.currentItemChopAmount);
        compound.setInteger("totalChopTime", this.totalItemChopAmount);
        return super.writeToNBT(compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (this.getStackInSlot(0).getCount() > 0) {
            this.currentItemChopAmount = compound.getInteger("chopTime");
            this.totalItemChopAmount = compound.getInteger("totalChopTime");
        } else {
            this.currentItemChopAmount = 0;
            this.totalItemChopAmount = 1;
        }
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index == 0 && HPRecipes.instance().hasChopperRecipe(stack, true) && this.getStackInSlot(1).isEmpty() && this.getStackInSlot(0).isEmpty();
    }

    public boolean chop(EntityPlayer player, ItemStack held) {
        if (this.canWork()) {
            ++this.currentItemChopAmount;
            if (this.currentItemChopAmount >= this.totalItemChopAmount) {
                this.currentItemChopAmount = 0;
                this.totalItemChopAmount = HPRecipes.instance().getChoppingTime(this.getStackInSlot(0), true);
                this.chopItem(player, held);
                return true;
            }
            this.markDirty();
        }
        return false;
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = this.getStackInSlot(index);
        super.setInventorySlotContents(index, stack);
        if (index == 1 && this.getStackInSlot(1).isEmpty()) {
            this.markDirty();
        }
        boolean bl = flag = !stack.isEmpty() && stack.isItemEqual(itemstack) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.totalItemChopAmount = HPRecipes.instance().getChoppingTime(stack, true);
            this.currentItemChopAmount = 0;
            this.markDirty();
        }
    }

    private void chopItem(EntityPlayer player, ItemStack held) {
        if (this.canWork()) {
            ItemStack input = this.getStackInSlot(0);
            if (!this.getWorld().isRemote) {
                ItemStack result = this.getRecipeItemStack();
                ItemStack output = this.getStackInSlot(1);
                double baseAmount = (double)TileEntityManualChopper.getBaseAmount(held, player) / 100.0;
                int chance = TileEntityManualChopper.getChance(held, player);
                result = result.copy();
                result.setCount((int)Math.ceil((double)result.getCount() * baseAmount));
                if (chance >= 100 || this.world.rand.nextInt(100) < chance) {
                    result.grow(1);
                }
                if (Configs.general.choppingBlockDrop) {
                    InventoryHelper.spawnItemStack((World)this.getWorld(), (double)this.getPos().getX(), (double)((double)this.getPos().getY() + 0.5), (double)this.getPos().getZ(), (ItemStack)result);
                } else if (output.isEmpty()) {
                    this.setInventorySlotContents(1, result);
                } else if (output.getItem() == result.getItem()) {
                    output.grow(result.getCount());
                }
            }
            this.getWorld().playSound(player, this.getPos(), SoundEvents.BLOCK_WOOD_BREAK, SoundCategory.BLOCKS, 1.0f, 1.0f);
            input.shrink(1);
            this.markDirty();
        }
    }

    public static int getBaseAmount(ItemStack axe, EntityPlayer player) {
        int baseAmount = 100;
        int harvestLevel = axe.getItem().getHarvestLevel(axe, "axe", player, null);
        if (harvestLevel > -1 && HPEventHandler.harvestPercentages.get(harvestLevel) != null) {
            baseAmount = (Integer)HPEventHandler.harvestPercentages.get(harvestLevel).getLeft();
        }
        for (Map.Entry<ItemStack, Pair<Integer, Integer>> entry : HPEventHandler.choppingAxes.entrySet()) {
            if (!entry.getKey().isItemEqual(axe)) continue;
            return (Integer)entry.getValue().getLeft();
        }
        return baseAmount;
    }

    public static int getChance(ItemStack axe, EntityPlayer player) {
        int chance = 0;
        int harvestLevel = axe.getItem().getHarvestLevel(axe, "axe", player, null);
        if (harvestLevel > -1 && HPEventHandler.harvestPercentages.get(harvestLevel) != null) {
            chance = (Integer)HPEventHandler.harvestPercentages.get(harvestLevel).getRight();
        }
        for (Map.Entry<ItemStack, Pair<Integer, Integer>> entry : HPEventHandler.choppingAxes.entrySet()) {
            if (!entry.getKey().isItemEqual(axe)) continue;
            return (Integer)entry.getValue().getRight();
        }
        return chance;
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getChopperResult(this.getStackInSlot(0), true);
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getChoppingBlockRecipe(this.getStackInSlot(0), true);
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.totalItemChopAmount;
            }
            case 1: {
                return this.currentItemChopAmount;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemChopAmount = value;
                break;
            }
            case 1: {
                this.currentItemChopAmount = value;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 3;
    }

    @Override
    public String getName() {
        return "container.manual_chopper";
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T cap = super.getCapability(capability, facing);
        return (T)(cap != null ? cap : (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.handlerSide : null));
    }
}

