/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.jei.ShapedChoppingCraftingWrapper;
import se.gory_moon.horsepower.jei.ShapelessChoppingCraftingWrapper;
import se.gory_moon.horsepower.jei.chopping.ChoppingRecipeMaker;
import se.gory_moon.horsepower.jei.chopping.ChoppingRecipeWrapper;
import se.gory_moon.horsepower.jei.chopping.HPChoppingCategory;
import se.gory_moon.horsepower.jei.chopping.manual.HPManualChoppingCategory;
import se.gory_moon.horsepower.jei.chopping.manual.ManualChoppingRecipeWrapper;
import se.gory_moon.horsepower.jei.grinding.GrindingRecipeMaker;
import se.gory_moon.horsepower.jei.grinding.GrindstoneRecipeWrapper;
import se.gory_moon.horsepower.jei.grinding.HorsePowerGrindingCategory;
import se.gory_moon.horsepower.jei.press.HorsePowerPressCategory;
import se.gory_moon.horsepower.jei.press.PressRecipeMaker;
import se.gory_moon.horsepower.jei.press.PressRecipeWrapper;
import se.gory_moon.horsepower.recipes.ChoppingBlockRecipe;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;
import se.gory_moon.horsepower.recipes.HandGrindstoneRecipe;
import se.gory_moon.horsepower.recipes.PressRecipe;
import se.gory_moon.horsepower.recipes.ShapedChoppingRecipe;
import se.gory_moon.horsepower.recipes.ShapelessChoppingRecipe;

@JEIPlugin
public class HorsePowerPlugin
implements IModPlugin {
    public static final String HAND_GRINDING = "horsepower.hand_grinding";
    public static final String GRINDING = "horsepower.grinding";
    public static final String MANUAL_CHOPPING = "horsepower.manual_chopping";
    public static final String CHOPPING = "horsepower.chopping";
    public static final String PRESS_ITEM = "horsepower.press";
    public static final String PRESS_FLUID = "horsepower.press_fluid";
    public static IJeiHelpers jeiHelpers;
    public static IGuiHelper guiHelper;
    public static IRecipeRegistry recipeRegistry;
    public static ICraftingGridHelper craftingGridHelper;
    public static IIngredientRegistry ingredientRegistry;

    public void register(IModRegistry registry) {
        ingredientRegistry = registry.getIngredientRegistry();
        jeiHelpers = registry.getJeiHelpers();
        guiHelper = jeiHelpers.getGuiHelper();
        craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
        if (Configs.recipes.useSeperateGrindstoneRecipes) {
            registry.handleRecipes(HandGrindstoneRecipe.class, GrindstoneRecipeWrapper::new, HAND_GRINDING);
            registry.addRecipes(GrindingRecipeMaker.getGrindstoneRecipes(jeiHelpers, true), HAND_GRINDING);
        }
        if (Configs.general.enableHandChoppingBlock) {
            ManualChoppingRecipeWrapper.setAxes();
            registry.handleRecipes(ChoppingBlockRecipe.class, ManualChoppingRecipeWrapper::new, MANUAL_CHOPPING);
            if (Configs.recipes.useSeperateChoppingRecipes) {
                registry.addRecipes(ChoppingRecipeMaker.getChoppingRecipes(jeiHelpers, true, true), MANUAL_CHOPPING);
            } else {
                registry.addRecipes(ChoppingRecipeMaker.getChoppingRecipes(jeiHelpers, true, false), MANUAL_CHOPPING);
            }
        }
        registry.handleRecipes(GrindstoneRecipe.class, GrindstoneRecipeWrapper::new, GRINDING);
        registry.addRecipes(GrindingRecipeMaker.getGrindstoneRecipes(jeiHelpers, false), GRINDING);
        registry.handleRecipes(ChoppingBlockRecipe.class, ChoppingRecipeWrapper::new, CHOPPING);
        registry.addRecipes(ChoppingRecipeMaker.getChoppingRecipes(jeiHelpers, false, false), CHOPPING);
        registry.handleRecipes(PressRecipe.class, PressRecipeWrapper::new, PRESS_ITEM);
        registry.handleRecipes(PressRecipe.class, PressRecipeWrapper::new, PRESS_FLUID);
        registry.addRecipes(PressRecipeMaker.getPressItemRecipes(jeiHelpers), PRESS_ITEM);
        registry.addRecipes(PressRecipeMaker.getPressFluidRecipes(jeiHelpers), PRESS_FLUID);
        registry.handleRecipes(ShapedChoppingRecipe.class, ShapedChoppingCraftingWrapper::new, "minecraft.crafting");
        registry.handleRecipes(ShapelessChoppingRecipe.class, ShapelessChoppingCraftingWrapper::new, "minecraft.crafting");
        if (Configs.recipes.useSeperateGrindstoneRecipes) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_HAND_GRINDSTONE), new String[]{HAND_GRINDING});
        } else {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_HAND_GRINDSTONE), new String[]{GRINDING});
        }
        if (Configs.general.enableHandChoppingBlock) {
            ItemStack itemStackManualChopper = BlockHPChoppingBase.createItemStack(ModBlocks.BLOCK_MANUAL_CHOPPER, 1, new ItemStack(Item.getItemFromBlock((Block)Blocks.LOG)));
            registry.addRecipeCatalyst((Object)itemStackManualChopper, new String[]{MANUAL_CHOPPING});
        }
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_GRINDSTONE), new String[]{GRINDING});
        ItemStack itemStackChopper = BlockHPChoppingBase.createItemStack(ModBlocks.BLOCK_CHOPPER, 1, new ItemStack(Item.getItemFromBlock((Block)Blocks.LOG)));
        registry.addRecipeCatalyst((Object)itemStackChopper, new String[]{CHOPPING});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_PRESS), new String[]{PRESS_ITEM});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.BLOCK_PRESS), new String[]{PRESS_FLUID});
        registry.addIngredientInfo((Object)new ItemStack((Block)ModBlocks.BLOCK_GRINDSTONE), VanillaTypes.ITEM, new String[]{"info.horsepower:grindstone.info1", "info.horsepower:grindstone.info2", "info.horsepower:grindstone.info3"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(Item.getItemFromBlock((Block)ModBlocks.BLOCK_CHOPPER), itemStack -> {
            NBTTagCompound nbtTagCompound = itemStack.getTagCompound();
            if (itemStack.getMetadata() == Short.MAX_VALUE || nbtTagCompound == null || nbtTagCompound.isEmpty()) {
                return null;
            }
            return nbtTagCompound.toString();
        });
        subtypeRegistry.registerSubtypeInterpreter(Item.getItemFromBlock((Block)ModBlocks.BLOCK_MANUAL_CHOPPER), itemStack -> {
            NBTTagCompound nbtTagCompound = itemStack.getTagCompound();
            if (itemStack.getMetadata() == Short.MAX_VALUE || nbtTagCompound == null || nbtTagCompound.isEmpty()) {
                return null;
            }
            return nbtTagCompound.toString();
        });
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (Configs.recipes.useSeperateGrindstoneRecipes) {
            registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerGrindingCategory(registry.getJeiHelpers().getGuiHelper(), true)});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerGrindingCategory(registry.getJeiHelpers().getGuiHelper(), false)});
        if (Configs.general.enableHandChoppingBlock) {
            registry.addRecipeCategories(new IRecipeCategory[]{new HPManualChoppingCategory(registry.getJeiHelpers().getGuiHelper())});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new HPChoppingCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerPressCategory(registry.getJeiHelpers().getGuiHelper(), false)});
        registry.addRecipeCategories(new IRecipeCategory[]{new HorsePowerPressCategory(registry.getJeiHelpers().getGuiHelper(), true)});
    }
}

