/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.items;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.recipes.ShapedChoppingRecipe;
import se.gory_moon.horsepower.recipes.ShapelessChoppingRecipe;

@GameRegistry.ObjectHolder(value="horsepower")
@Mod.EventBusSubscriber(modid="horsepower")
public class ModItems {
    public static final Item FLOUR = ((Item)new Item().setRegistryName("flour")).setTranslationKey("flour").setCreativeTab((CreativeTabs)HorsePowerMod.creativeTab);
    public static final Item DOUGH = ((Item)new Item().setRegistryName("dough")).setTranslationKey("dough").setCreativeTab((CreativeTabs)HorsePowerMod.creativeTab);
    private static Set<Map.Entry<ResourceLocation, IRecipe>> recipes;
    private static List<ResourceLocation> recipesToRemove;

    public static void registerRecipes() {
        if (Configs.general.enableDough) {
            GameRegistry.addSmelting((Item)DOUGH, (ItemStack)new ItemStack(Items.BREAD), (float)0.0f);
            OreDictionary.registerOre((String)"foodDough", (Item)DOUGH);
        }
        if (Configs.general.enableFlour) {
            OreDictionary.registerOre((String)"foodFlour", (Item)FLOUR);
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> ev) throws NoSuchFieldException, IllegalAccessException {
        recipes = ev.getRegistry().getEntries();
        ResourceLocation loc = new ResourceLocation("horsepower:chopper");
        ev.getRegistry().register(new ShapedChoppingRecipe(loc, (List<ItemStack>)OreDictionary.getOres((String)"logWood"), new ItemStack((Block)ModBlocks.BLOCK_CHOPPER), "LSL", "SFS", "SWS", Character.valueOf('S'), "stickWood", Character.valueOf('L'), Ingredient.fromStacks((ItemStack[])new ItemStack[]{new ItemStack(Items.LEAD)}), Character.valueOf('F'), Ingredient.fromStacks((ItemStack[])new ItemStack[]{new ItemStack(Items.FLINT)}), Character.valueOf('W'), "logWood").setRegistryName(loc));
        if (Configs.general.enableHandChoppingBlock) {
            loc = new ResourceLocation("horsepower:manual_chopping");
            ev.getRegistry().register(new ShapelessChoppingRecipe(loc, (List<ItemStack>)OreDictionary.getOres((String)"logWood"), new ItemStack((Block)ModBlocks.BLOCK_MANUAL_CHOPPER, 2), "logWood", Items.FLINT).setRegistryName(loc));
        }
        if (Configs.general.removeVanillaRecipes) {
            ModItems.removeRecipes();
        }
    }

    private static void removeRecipes() {
        Container dummyContainer = new Container(){

            public boolean canInteractWith(EntityPlayer entityplayer) {
                return true;
            }

            public void onCraftMatrixChanged(IInventory par1IInventory) {
            }
        };
        InventoryCrafting crafting = new InventoryCrafting(dummyContainer, 3, 3);
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "###", Character.valueOf('#'), Items.WHEAT)));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), Items.REEDS)));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack(Blocks.BONE_BLOCK))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), Items.BONE)));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), Items.BEETROOT)));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.YELLOW_FLOWER, 1, BlockFlower.EnumFlowerType.DANDELION.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.POPPY.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.BLUE_ORCHID.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.ALLIUM.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.HOUSTONIA.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.RED_TULIP.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.ORANGE_TULIP.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.WHITE_TULIP.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.PINK_TULIP.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.RED_FLOWER, 1, BlockFlower.EnumFlowerType.OXEYE_DAISY.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.DOUBLE_PLANT, 1, BlockDoublePlant.EnumPlantType.SUNFLOWER.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.DOUBLE_PLANT, 1, BlockDoublePlant.EnumPlantType.SYRINGA.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.DOUBLE_PLANT, 1, BlockDoublePlant.EnumPlantType.ROSE.getMeta()))));
        ModItems.removeRecipe(ModItems.findMatchingRecipe(ModItems.setRecipe(crafting, "#", Character.valueOf('#'), new ItemStack((Block)Blocks.DOUBLE_PLANT, 1, BlockDoublePlant.EnumPlantType.PAEONIA.getMeta()))));
        recipesToRemove.forEach(recipe -> RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).remove(recipe));
    }

    private static InventoryCrafting setRecipe(InventoryCrafting crafting, Object ... recipeComponents) {
        crafting.clear();
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipeComponents[i] instanceof String[]) {
            String[] astring;
            for (String s2 : astring = (String[])recipeComponents[i++]) {
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap map = Maps.newHashMap();
        while (i < recipeComponents.length) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack = ItemStack.EMPTY;
            if (recipeComponents[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)recipeComponents[i + 1], 1, Short.MAX_VALUE);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)recipeComponents[i + 1];
            }
            map.put(character, itemstack);
            i += 2;
        }
        for (int l = 0; l < j * k; ++l) {
            char c0 = s.charAt(l);
            if (!map.containsKey(Character.valueOf(c0))) continue;
            crafting.setInventorySlotContents(l, ((ItemStack)map.get(Character.valueOf(c0))).copy());
        }
        return crafting;
    }

    private static void removeRecipesWithResult(ItemStack resultItem) {
        for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
            ItemStack recipeResult = recipe.getValue().getRecipeOutput();
            if (!ItemStack.areItemStacksEqual((ItemStack)resultItem, (ItemStack)recipeResult)) continue;
            recipesToRemove.add(recipe.getKey());
        }
    }

    private static void removeRecipe(ResourceLocation recipe) {
        if (recipe != null) {
            recipesToRemove.add(recipe);
        }
    }

    public static ResourceLocation findMatchingRecipe(InventoryCrafting craftMatrix) {
        for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
            if (!recipe.getValue().matches(craftMatrix, null)) continue;
            return recipe.getKey();
        }
        return null;
    }

    static {
        recipesToRemove = new LinkedList<ResourceLocation>();
    }

    @Mod.EventBusSubscriber(modid="horsepower")
    public static class RegistrationHandler {
        public static final Set<Item> ITEMS = new HashSet<Item>();

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            Item[] items = new Item[]{FLOUR, DOUGH};
            IForgeRegistry registry = event.getRegistry();
            for (Item item : items) {
                if (!Configs.general.enableFlour && item == FLOUR || !Configs.general.enableDough && item == DOUGH) continue;
                registry.register((IForgeRegistryEntry)item);
                ITEMS.add(item);
            }
        }
    }
}

