package se.gory_moon.horsepower.client.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.lwjgl.opengl.GL11;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.blocks.BlockPress;
import se.gory_moon.horsepower.client.model.modelvariants.PressModels;
import se.gory_moon.horsepower.tileentity.TileEntityPress;
import se.gory_moon.horsepower.util.RenderUtils;

public class TileEntityPressRender extends TileEntityHPBaseRenderer<TileEntityPress> {

    @Override
    public void func_192841_a(TileEntityPress te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBlockState blockState = te.func_145831_w().func_180495_p( te.func_174877_v() );
        if (!(blockState.func_177230_c() instanceof BlockHPBase)) return;
        IBlockState topState = blockState.func_177226_a(BlockPress.PART, PressModels.TOP);
        if (!(topState.func_177230_c() instanceof BlockHPBase)) return;
        IBakedModel pressModel = dispatcher.func_175023_a().func_178125_b(topState);

        preDestroyRender(destroyStage);
        setRenderSettings();

        buffer.func_181668_a( GL11.GL_QUADS, DefaultVertexFormats.field_176600_a );
        // The translation ensures the vertex buffer positions are relative to 0,0,0 instead of the block pos
        // This makes the translations that follow much easier
        buffer.func_178969_c( -te.func_174877_v().func_177958_n(), -te.func_174877_v().func_177956_o(), -te.func_174877_v().func_177952_p());

        if (destroyStage >= 0) {
            buffer.func_78914_f();
            renderBlockDamage(topState, te.func_174877_v(), getDestroyBlockIcon(destroyStage), te.func_145831_w());
        } else
            dispatcher.func_175019_b().func_178267_a( te.func_145831_w(), pressModel, blockState, te.func_174877_v(), buffer, false );

        buffer.func_178969_c( 0, 0, 0 );

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b( x, y, z );

        // Apply GL transformations relative to the center of the block: 1) TE rotation and 2) crank rotation
        float move = (te.getField(0) / (float)(Configs.general.pointsForPress > 0 ? Configs.general.pointsForPress: 1));
        GlStateManager.func_179137_b( 0.5, 0.5, 0.5 );
        GlStateManager.func_179137_b( 0, -( 0.58 * move), 0 );
        GlStateManager.func_179137_b( -0.5, -0.5, -0.5 );

        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        postDestroyRender(destroyStage);
        RenderHelper.func_74519_b();

        if (!(blockState.func_177230_c() instanceof BlockHPBase)) return;

        if (te.hasWorker())
            renderLeash(te.getWorker(), x, y, z, 0D, 0.4D, 0D, partialTicks, te.func_174877_v());

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b(x, y, z);
        if (!te.getStackInSlot(0).func_190926_b() && move <= 0.25) {
            renderItem(te, te.getStackInSlot(0), 0.5F, 0.5F, 0.5F, 1F);
            drawString(te, String.valueOf(te.getStackInSlot(0).func_190916_E()), 0, 0.35, 0);
        }

        if (!te.getStackInSlot(1).func_190926_b() && move <= 0.25) {
            renderItem(te, te.getStackInSlot(1), 0.5F, 0.5F, 0.5F, 1F);
            drawString(te, String.valueOf(te.getStackInSlot(1).func_190916_E()), 0, 0.35,  0);
        }
        GlStateManager.func_179121_F();


        IFluidTankProperties tankProperties = te.getTankFluidStack()[0];
        FluidStack stack = tankProperties.getContents();
        if (stack != null && move <= 0.25) {
            float amount = (0.75F / ((float) tankProperties.getCapacity())) * stack.amount;
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(stack.getFluid().getStill().toString());
            int fluidColor = stack.getFluid().getColor(stack);

            GlStateManager.func_179140_f();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179137_b(x, y + 0.07, z);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            float red = (fluidColor >> 16 & 0xFF) / 255.0F;
            float green = (fluidColor >> 8 & 0xFF) / 255.0F;
            float blue = (fluidColor & 0xFF) / 255.0F;
            GlStateManager.func_179131_c(red, green, blue, 1.0F);
            buffer.func_181668_a(GL11.GL_QUADS, DefaultVertexFormats.field_181707_g);

            float xMax = 0.9f;
            float zMax = 0.9f;
            float xMin = 0.1f;
            float zMin = 0.1f;
            double uMin = (double) sprite.func_94209_e();
            double uMax = (double) sprite.func_94212_f();
            double vMin = (double) sprite.func_94206_g();
            double vMax = (double) sprite.func_94210_h();

            buffer.func_181662_b(xMax, amount, zMax).func_187315_a(uMax, vMin).func_181675_d();
            buffer.func_181662_b(xMax, amount, zMin).func_187315_a(uMin, vMax).func_181675_d();
            buffer.func_181662_b(xMin, amount, zMin).func_187315_a(uMin, vMax).func_181675_d();
            buffer.func_181662_b(xMin, amount, zMax).func_187315_a(uMax, vMin).func_181675_d();

            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();

        }

        GlStateManager.func_179094_E();
        drawDisplayText(te, x, y + 1, z);

        if (!te.isValid())
            RenderUtils.renderInvalidArea(te.func_145831_w(), te.func_174877_v(), 0);
        GlStateManager.func_179121_F();
    }
}
