/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.util;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static TextureAtlasSprite getTopTextureFromBlock(Block block, int meta) {
        IBlockState state = block.getStateFromMeta(meta);
        return RenderUtils.getTopTextureFromBlockstate(state);
    }

    public static TextureAtlasSprite getTopTextureFromBlockstate(IBlockState state) {
        IBakedModel model = Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelForState(state);
        if (model != Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelManager().getMissingModel()) {
            List quads = model.getQuads(state, EnumFacing.UP, 0L);
            return quads.size() >= 1 ? ((BakedQuad)quads.get(0)).getSprite() : Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getTexture(state);
        }
        return Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getTexture(state);
    }

    public static TextureAtlasSprite getTextureFromBlock(Block block, int meta) {
        IBlockState state = block.getStateFromMeta(meta);
        return Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getTexture(state);
    }

    public static TextureAtlasSprite getTextureFromBlockstate(IBlockState state) {
        return Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getTexture(state);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms(IBakedModel model) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TRSRTransformation transformation = new TRSRTransformation((Matrix4f)model.handlePerspective(type).getRight());
            if (transformation.equals((Object)TRSRTransformation.identity())) continue;
            builder.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)transformation));
        }
        return builder.build();
    }

    public static void renderInvalidArea(World world, BlockPos blockPos, int yOffset) {
        if (StreamSupport.stream(Minecraft.getMinecraft().player.getHeldEquipment().spliterator(), false).anyMatch(stack -> !stack.isEmpty() && stack.getItem() == Items.LEAD)) {
            RenderUtils.renderUsedArea(world, blockPos, yOffset, 0.55f, 0.15f);
        }
    }

    public static void renderUsedArea(World world, BlockPos blockPos, int yOffset, float invalidAplha, float validAplha) {
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.alphaFunc((int)516, (float)0.0f);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2848);
        GlStateManager.enableDepth();
        GlStateManager.glLineWidth((float)2.0f);
        GlStateManager.doPolygonOffset((float)-0.1f, (float)-10.0f);
        GlStateManager.enablePolygonOffset();
        for (int xo = -3; xo <= 3; ++xo) {
            for (int yo = yOffset; yo <= 1 + yOffset; ++yo) {
                for (int zo = -3; zo <= 3; ++zo) {
                    BlockPos pos = blockPos.add(xo, yo, zo);
                    if (xo <= 1 && xo >= -1 && zo <= 1 && zo >= -1 || pos.getY() < 0) continue;
                    IBlockState state = world.getBlockState(pos);
                    if (!state.getBlock().isReplaceable((IBlockAccess)world, pos)) {
                        GlStateManager.color((float)1.0f, (float)0.0f, (float)0.0f, (float)invalidAplha);
                        RenderUtils.drawBoundingBoxOutline(new AxisAlignedBB(pos).offset(-Minecraft.getMinecraft().getRenderManager().viewerPosX, -Minecraft.getMinecraft().getRenderManager().viewerPosY, -Minecraft.getMinecraft().getRenderManager().viewerPosZ));
                        RenderUtils.drawBoundingBox(state.getBoundingBox((IBlockAccess)world, pos).offset(pos).offset(-Minecraft.getMinecraft().getRenderManager().viewerPosX, -Minecraft.getMinecraft().getRenderManager().viewerPosY, -Minecraft.getMinecraft().getRenderManager().viewerPosZ));
                        continue;
                    }
                    GlStateManager.color((float)0.0f, (float)1.0f, (float)0.0f, (float)validAplha);
                    RenderUtils.drawBoundingBoxOutline(new AxisAlignedBB(pos).offset(-Minecraft.getMinecraft().getRenderManager().viewerPosX, -Minecraft.getMinecraft().getRenderManager().viewerPosY, -Minecraft.getMinecraft().getRenderManager().viewerPosZ));
                }
            }
        }
        GlStateManager.disablePolygonOffset();
        GL11.glDisable((int)2848);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture2D();
        GlStateManager.enableDepth();
        GlStateManager.disableBlend();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBoundingBox(AxisAlignedBB axisalignedbb) {
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.minX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.minZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.maxY, (double)axisalignedbb.maxZ);
        GL11.glVertex3d((double)axisalignedbb.maxX, (double)axisalignedbb.minY, (double)axisalignedbb.maxZ);
        GL11.glEnd();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBoundingBoxOutline(AxisAlignedBB par1AxisAlignedBB) {
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)par1AxisAlignedBB.minX, (double)par1AxisAlignedBB.minY, (double)par1AxisAlignedBB.minZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.maxX, (double)par1AxisAlignedBB.minY, (double)par1AxisAlignedBB.minZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.maxX, (double)par1AxisAlignedBB.minY, (double)par1AxisAlignedBB.maxZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.minX, (double)par1AxisAlignedBB.minY, (double)par1AxisAlignedBB.maxZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.minX, (double)par1AxisAlignedBB.minY, (double)par1AxisAlignedBB.minZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.minX, (double)par1AxisAlignedBB.maxY, (double)par1AxisAlignedBB.minZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.maxX, (double)par1AxisAlignedBB.maxY, (double)par1AxisAlignedBB.minZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.maxX, (double)par1AxisAlignedBB.maxY, (double)par1AxisAlignedBB.maxZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.minX, (double)par1AxisAlignedBB.maxY, (double)par1AxisAlignedBB.maxZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.minX, (double)par1AxisAlignedBB.maxY, (double)par1AxisAlignedBB.minZ);
        GL11.glEnd();
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)par1AxisAlignedBB.minX, (double)par1AxisAlignedBB.minY, (double)par1AxisAlignedBB.minZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.minX, (double)par1AxisAlignedBB.maxY, (double)par1AxisAlignedBB.minZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.maxX, (double)par1AxisAlignedBB.minY, (double)par1AxisAlignedBB.minZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.maxX, (double)par1AxisAlignedBB.maxY, (double)par1AxisAlignedBB.minZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.maxX, (double)par1AxisAlignedBB.minY, (double)par1AxisAlignedBB.maxZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.maxX, (double)par1AxisAlignedBB.maxY, (double)par1AxisAlignedBB.maxZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.minX, (double)par1AxisAlignedBB.minY, (double)par1AxisAlignedBB.maxZ);
        GL11.glVertex3d((double)par1AxisAlignedBB.minX, (double)par1AxisAlignedBB.maxY, (double)par1AxisAlignedBB.maxZ);
        GL11.glEnd();
    }
}

