/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei.grinding;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.jei.HorsePowerCategory;
import se.gory_moon.horsepower.jei.HorsePowerPlugin;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.Utils;
import se.gory_moon.horsepower.util.color.Colors;

public class GrindstoneRecipeWrapper
implements IRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final ItemStack output;
    private final ItemStack secondary;
    private final int secondaryChance;
    private final int time;
    private final double printLaps;
    private final IDrawableAnimated arrow;

    public GrindstoneRecipeWrapper(GrindstoneRecipe recipe) {
        this(Collections.singletonList(recipe.getInput()), recipe.getOutput(), recipe.getSecondary(), recipe.getSecondaryChance(), recipe.getTime());
    }

    public GrindstoneRecipeWrapper(List<ItemStack> inputs, ItemStack output, ItemStack secondary, int secondaryChance, int time) {
        this.inputs = Collections.singletonList(inputs);
        this.output = output;
        this.secondary = secondary;
        this.secondaryChance = secondaryChance;
        this.time = time;
        IGuiHelper guiHelper = HorsePowerPlugin.guiHelper;
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(HorsePowerCategory.COMPONENTS, 60, 0, 24, 17);
        int laps = (int)((double)time / 8.0 * 100.0);
        this.printLaps = (double)Math.round((double)time / 8.0 * 100.0) / 100.0;
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, laps, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutputs(VanillaTypes.ITEM, (List)Lists.newArrayList((Object[])new ItemStack[]{this.output, this.secondary}));
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.arrow.draw(minecraft, 57, 27);
        minecraft.fontRenderer.drawStringWithShadow("x" + this.printLaps, 33.0f, 48.0f, Colors.WHITE.getRGB());
        if (this.secondaryChance > 0) {
            minecraft.fontRenderer.drawString(this.secondaryChance + "%", 65, 58, 0x808080);
        }
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 55 && mouseY >= 21 && mouseX < 80 && mouseY < 45) {
            tooltip.add(Localization.GUI.JEI.GRINDING.translate(this.printLaps, this.printLaps >= 2.0));
        }
        return tooltip;
    }

    public int getSecondaryChance() {
        return this.secondaryChance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GrindstoneRecipeWrapper)) {
            return false;
        }
        GrindstoneRecipeWrapper that = (GrindstoneRecipeWrapper)o;
        boolean flag = true;
        for (ItemStack stack : this.inputs.get(0)) {
            for (ItemStack stack1 : that.inputs.get(0)) {
                if (stack1.getMetadata() != Short.MAX_VALUE || OreDictionary.itemMatches((ItemStack)stack, (ItemStack)stack1, (boolean)false)) continue;
                flag = false;
            }
        }
        return this.time == that.time && flag && this.output.equals(that.output);
    }

    public int hashCode() {
        int result = this.inputs.stream().map(itemStacks -> itemStacks.stream().map(Utils::getItemStackHashCode).collect(Collectors.toList())).hashCode();
        result = 31 * result + Utils.getItemStackHashCode(this.output);
        result = 31 * result + Utils.getItemStackHashCode(this.secondary);
        result = 31 * result + this.secondaryChance;
        result = 31 * result + this.time;
        return result;
    }
}

