/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.recipes.PressRecipe;
import se.gory_moon.horsepower.tileentity.TileEntityHPHorseBase;
import se.gory_moon.horsepower.util.Localization;

public class TileEntityPress
extends TileEntityHPHorseBase {
    private FluidTank tank;
    private int currentPressStatus;

    public TileEntityPress() {
        super(2);
        this.tank = new FluidTank(Configs.general.pressFluidTankSize);
        this.tank.setCanFill(false);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.setInteger("currentPressStatus", this.currentPressStatus);
        compound.setTag("fluid", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return super.writeToNBT(compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.tank.readFromNBT(compound.getCompoundTag("fluid"));
        this.currentPressStatus = this.getStackInSlot(0).getCount() > 0 ? compound.getInteger("currentPressStatus") : 0;
    }

    @Override
    public void markDirty() {
        if (this.getStackInSlot(0).isEmpty()) {
            this.currentPressStatus = 0;
        }
        super.markDirty();
    }

    @Override
    public boolean validateArea() {
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x <= 1 && x >= -1 && z <= 1 && z >= -1) continue;
                    this.searchPos.add(this.getPos().add(x, 0, z));
                    this.searchPos.add(this.getPos().add(x, 1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            if (this.getWorld().getBlockState(pos).getBlock().isReplaceable((IBlockAccess)this.world, pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean targetReached() {
        ++this.currentPressStatus;
        int totalPress = Configs.general.pointsForPress;
        if (this.currentPressStatus >= (totalPress <= 0 ? 1 : totalPress)) {
            this.currentPressStatus = 0;
            this.pressItem();
            return true;
        }
        this.markDirty();
        return false;
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getPressRecipe(this.getStackInSlot(0));
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getPressResult(this.getStackInSlot(0));
    }

    @Override
    public int getPositionOffset() {
        return 0;
    }

    private void pressItem() {
        if (this.canWork()) {
            PressRecipe recipe = (PressRecipe)this.getRecipe();
            ItemStack result = recipe.getOutput();
            FluidStack fluidResult = recipe.getOutputFluid();
            ItemStack input = this.getStackInSlot(0);
            ItemStack output = this.getStackInSlot(1);
            if (recipe.isLiquidRecipe()) {
                this.tank.fillInternal(fluidResult, true);
                HorsePowerMod.logger.info("Tank: " + this.tank.getFluid().amount);
            } else if (output.isEmpty()) {
                this.setInventorySlotContents(1, result.copy());
            } else if (output.isItemEqual(result)) {
                output.grow(result.getCount());
            }
            input.shrink(input.getCount());
            this.markDirty();
        }
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = this.getStackInSlot(index);
        super.setInventorySlotContents(index, stack);
        boolean bl = flag = !stack.isEmpty() && stack.isItemEqual(itemstack) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.currentPressStatus = 0;
        }
        this.markDirty();
    }

    @Override
    public boolean canWork() {
        if (this.getStackInSlot(0).isEmpty()) {
            return false;
        }
        PressRecipe recipe = (PressRecipe)this.getRecipe();
        if (recipe == null) {
            return false;
        }
        ItemStack input = recipe.getInput();
        ItemStack itemstack = recipe.getOutput();
        FluidStack fluidOutput = recipe.getOutputFluid();
        if (this.getStackInSlot(0).getCount() < input.getCount()) {
            return false;
        }
        if (itemstack.isEmpty() && !recipe.isLiquidRecipe()) {
            return false;
        }
        ItemStack output = this.getStackInSlot(1);
        if (recipe.isLiquidRecipe()) {
            return output.isEmpty() && (this.tank.getFluidAmount() == 0 || this.tank.fillInternal(fluidOutput, false) >= fluidOutput.amount);
        }
        return this.tank.getFluidAmount() == 0 && (output.isEmpty() || output.isItemEqual(itemstack) && output.getCount() + itemstack.getCount() <= output.getMaxStackSize());
    }

    @Override
    public int getInventoryStackLimit(ItemStack stack) {
        PressRecipe recipe = HPRecipes.instance().getPressRecipe(stack);
        if (recipe == null) {
            return this.getInventoryStackLimit();
        }
        return recipe.getInput().getCount();
    }

    @Override
    public ItemStack removeStackFromSlot(int index) {
        return this.currentPressStatus == 0 ? super.removeStackFromSlot(index) : ItemStack.EMPTY;
    }

    @Override
    public int getInventoryStackLimit() {
        PressRecipe recipe = HPRecipes.instance().getPressRecipe(this.getStackInSlot(0));
        if (recipe == null) {
            return 64;
        }
        return recipe.getInput().getCount();
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index == 0 && HPRecipes.instance().hasPressRecipe(stack) && this.currentPressStatus == 0 && this.getStackInSlot(1).isEmpty();
    }

    public IFluidTankProperties[] getTankFluidStack() {
        return this.tank.getTankProperties();
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.currentPressStatus;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.currentPressStatus = value;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 1;
    }

    @Override
    public String getName() {
        return "container.press";
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        if (this.valid) {
            return super.getDisplayName();
        }
        return new TextComponentTranslation(Localization.INFO.PRESS_INVALID.key(), new Object[0]).setStyle(new Style().setColor(TextFormatting.RED));
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing == EnumFacing.DOWN) || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing == EnumFacing.DOWN)) {
            return (T)this.tank;
        }
        return super.getCapability(capability, facing);
    }
}

