/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei.press;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.util.ResourceLocation;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.jei.HorsePowerCategory;
import se.gory_moon.horsepower.jei.press.PressRecipeWrapper;
import se.gory_moon.horsepower.util.Localization;

public class HorsePowerPressCategory
extends HorsePowerCategory<PressRecipeWrapper> {
    private static final int inputSlot = 0;
    private static final int outputSlot = 1;
    private final String localizedName;
    private boolean isLiquid;

    public HorsePowerPressCategory(IGuiHelper guiHelper, boolean isLiquid) {
        super(guiHelper);
        this.isLiquid = isLiquid;
        if (isLiquid) {
            this.background = guiHelper.createDrawable(new ResourceLocation("horsepower", "textures/gui/jei_fluid.png"), 0, 0, 146, 74);
        }
        this.localizedName = isLiquid ? Localization.GUI.CATEGORY_PRESS_FLUID.translate(new String[0]) : Localization.GUI.CATEGORY_PRESS_ITEM.translate(new String[0]);
    }

    public String getUid() {
        return this.isLiquid ? "horsepower.press_fluid" : "horsepower.press";
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Horse Power";
    }

    public void setRecipe(IRecipeLayout recipeLayout, PressRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStack = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 34, 32);
        if (this.isLiquid) {
            guiFluidStack.init(1, false, 95, 23, 16, 27, Configs.general.pressFluidTankSize, true, null);
        } else {
            guiItemStacks.init(1, false, 90, 32);
        }
        guiItemStacks.set(ingredients);
        if (this.isLiquid) {
            guiFluidStack.set(ingredients);
        }
        super.openRecipe();
    }
}

