/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.jei.HorsePowerPlugin;
import se.gory_moon.horsepower.recipes.ShapelessChoppingRecipe;

public class ShapelessChoppingCraftingWrapper
implements IRecipeWrapper,
ICustomCraftingRecipeWrapper {
    private final ShapelessChoppingRecipe recipe;
    private final List<List<ItemStack>> outputs;

    public ShapelessChoppingCraftingWrapper(ShapelessChoppingRecipe recipe) {
        this.recipe = recipe;
        for (Object input : this.recipe.getIngredients()) {
            ItemStack itemStack;
            if (!(input instanceof ItemStack) || (itemStack = (ItemStack)input).getCount() == 1) continue;
            itemStack.setCount(1);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack stack : recipe.outputBlocks) {
            BlockHPChoppingBase block = (BlockHPChoppingBase)Block.getBlockFromItem((Item)recipe.getSimpleRecipeOutput().getItem());
            if (!Configs.general.useDynamicCrafting && !"minecraft".equals(stack.getItem().getRegistryName().getResourceDomain())) {
                builder.add((Object)BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().getCount(), new ItemStack(Blocks.LOG)));
                break;
            }
            if (stack.getItemDamage() == Short.MAX_VALUE) {
                for (ItemStack sub : HorsePowerPlugin.jeiHelpers.getStackHelper().getSubtypes(stack)) {
                    builder.add((Object)BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().getCount(), sub));
                }
                continue;
            }
            if (Block.getBlockFromItem((Item)stack.getItem()) instanceof BlockHPChoppingBase) {
                NonNullList stacks = NonNullList.create();
                Block.getBlockFromItem((Item)stack.getItem()).getSubBlocks(null, stacks);
                for (ItemStack sub : stacks) {
                    builder.add((Object)BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().getCount(), sub));
                }
                continue;
            }
            builder.add((Object)BlockHPChoppingBase.createItemStack(block, recipe.getSimpleRecipeOutput().getCount(), stack));
        }
        this.outputs = ImmutableList.of((Object)builder.build());
    }

    public void getIngredients(IIngredients ingredients) {
        IStackHelper stackHelper = HorsePowerPlugin.jeiHelpers.getStackHelper();
        List inputs = stackHelper.expandRecipeItemStackInputs((List)this.recipe.getIngredients());
        ingredients.setInputLists(ItemStack.class, inputs);
        if (!this.outputs.isEmpty()) {
            ingredients.setOutputLists(ItemStack.class, this.outputs);
        }
    }

    private boolean isOutputBlock(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (ItemStack output : this.recipe.outputBlocks) {
            if (!OreDictionary.itemMatches((ItemStack)output, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        recipeLayout.setShapeless();
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = (List)ingredients.getOutputs(ItemStack.class).get(0);
        IFocus ifocus = recipeLayout.getFocus();
        Object focusObj = ifocus.getValue();
        if (focusObj instanceof ItemStack) {
            IGuiIngredientGroup guiIngredients = recipeLayout.getIngredientsGroup(ItemStack.class);
            ItemStack focus = (ItemStack)focusObj;
            IFocus.Mode mode = ifocus.getMode();
            if (mode == IFocus.Mode.INPUT && this.isOutputBlock(focus)) {
                BlockHPChoppingBase block = (BlockHPChoppingBase)Block.getBlockFromItem((Item)this.recipe.getSimpleRecipeOutput().getItem());
                ItemStack outputFocus = BlockChopper.createItemStack(block, 1, focus);
                guiIngredients.setOverrideDisplayFocus(HorsePowerPlugin.recipeRegistry.createFocus(IFocus.Mode.OUTPUT, (Object)outputFocus));
            } else if (mode == IFocus.Mode.OUTPUT) {
                ItemStack base = new ItemStack(focus.hasTagCompound() ? focus.getTagCompound().getCompoundTag("textureBlock") : new NBTTagCompound());
                if (Block.getBlockFromItem((Item)this.recipe.outputBlocks.get(0).getItem()) instanceof BlockHPChoppingBase) {
                    base = this.recipe.outputBlocks.get(0).copy();
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.setTag("textureBlock", (NBTBase)(focus.hasTagCompound() ? focus.getTagCompound().getCompoundTag("textureBlock") : new NBTTagCompound()));
                    base.setTagCompound(tag);
                }
                if (!base.isEmpty()) {
                    guiIngredients.setOverrideDisplayFocus(HorsePowerPlugin.recipeRegistry.createFocus(IFocus.Mode.INPUT, (Object)base));
                }
            }
        }
        HorsePowerPlugin.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
        recipeLayout.getItemStacks().set(0, outputs);
    }
}

