package se.gory_moon.horsepower.recipes;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;

import javax.annotation.Nonnull;
import java.util.List;

import static se.gory_moon.horsepower.blocks.BlockHPChoppingBase.createItemStack;

public class ShapelessChoppingRecipe extends ShapelessOreRecipe {

    public final List<ItemStack> outputBlocks;

    public ShapelessChoppingRecipe(ResourceLocation location, List<ItemStack> variantItems, ItemStack result, Object... recipe) {
        super(location, result, recipe);
        this.outputBlocks = variantItems;
        for (ItemStack stack : outputBlocks) {
            if (Block.func_149634_a(stack.func_77973_b()) instanceof BlockHPChoppingBase) {
                for (int i = 0; i < input.size(); i++) {
                    Ingredient ingredient = input.get(i);
                    if (ingredient.apply(stack)) {
                        NonNullList<ItemStack> stacks = NonNullList.func_191196_a();
                        Block.func_149634_a(stack.func_77973_b()).func_149666_a(null, stacks);
                        input.set(i, Ingredient.func_193369_a(stacks.toArray(new ItemStack[stacks.size()])));
                    }
                }
            }
        }
    }

    @Nonnull
    @Override
    public ItemStack func_77572_b(@Nonnull InventoryCrafting craftMatrix) {
        boolean isTypeChopping = false;
        for (ItemStack outputBlock : outputBlocks) {
            if (((ItemBlock) outputBlock.func_77973_b()).func_179223_d() instanceof BlockHPChoppingBase)
                isTypeChopping = true;
        }
        for(int i = 0; i < craftMatrix.func_70302_i_(); i++) {
            for (ItemStack ore: outputBlocks) {
                ItemStack stack = craftMatrix.func_70301_a(i);
                if ((OreDictionary.itemMatches(ore, stack, false) || (isTypeChopping && (Block.func_149634_a(stack.func_77973_b())) instanceof BlockHPChoppingBase)) && Block.func_149634_a(stack.func_77973_b()) != Blocks.field_150350_a) {
                    BlockHPChoppingBase block = (BlockHPChoppingBase) Block.func_149634_a(getSimpleRecipeOutput().func_77973_b());
                    if (!Configs.general.useDynamicCrafting) {
                        if ("minecraft".equals(ore.func_77973_b().getRegistryName().func_110624_b()))
                            return createItemStack(block, getSimpleRecipeOutput().func_190916_E(), stack);
                        else
                            return createItemStack(block, getSimpleRecipeOutput().func_190916_E(), new ItemStack(Blocks.field_150364_r, 1, 0));
                    }
                    return createItemStack(block, getSimpleRecipeOutput().func_190916_E(), stack);
                }
            }
        }
        return super.func_77572_b(craftMatrix);
    }

    @Nonnull
    @Override
    public ItemStack func_77571_b() {
        if (!outputBlocks.isEmpty() && !output.func_190926_b()) {
            ItemStack stack = outputBlocks.get(0).func_77946_l();
            BlockHPChoppingBase block = (BlockHPChoppingBase) Block.func_149634_a(output.func_77973_b());
            int meta = stack.func_77960_j();
            if (meta == OreDictionary.WILDCARD_VALUE)
                stack.func_77964_b(0);
            return createItemStack(block, getSimpleRecipeOutput().func_190916_E(), stack);

        }
        return super.func_77571_b();
    }

    public ItemStack getSimpleRecipeOutput() {
        return output;
    }
}
