package se.gory_moon.horsepower.client.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.*;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.blocks.BlockPress;
import se.gory_moon.horsepower.client.model.modelvariants.PressModels;
import se.gory_moon.horsepower.tileentity.TileEntityPress;
import se.gory_moon.horsepower.util.RenderUtils;

public class TileEntityPressRender extends TileEntityHPBaseRenderer<TileEntityPress> {

    @Override
    public void func_192841_a(TileEntityPress te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBlockState blockState = te.func_145831_w().func_180495_p( te.func_174877_v() );
        if (!(blockState.func_177230_c() instanceof BlockHPBase)) return;
        IBlockState topState = blockState.func_177226_a(BlockPress.PART, PressModels.TOP);
        if (!(topState.func_177230_c() instanceof BlockHPBase)) return;
        IBakedModel pressModel = dispatcher.func_175023_a().func_178125_b(topState);

        preDestroyRender(destroyStage);
        setRenderSettings();

        buffer.func_181668_a( GL11.GL_QUADS, DefaultVertexFormats.field_176600_a );
        // The translation ensures the vertex buffer positions are relative to 0,0,0 instead of the block pos
        // This makes the translations that follow much easier
        buffer.func_178969_c( -te.func_174877_v().func_177958_n(), -te.func_174877_v().func_177956_o(), -te.func_174877_v().func_177952_p() );

        if (destroyStage >= 0) {
            buffer.func_78914_f();
            renderBlockDamage(topState, te.func_174877_v(), getDestroyBlockIcon(destroyStage), te.func_145831_w());
        } else
            dispatcher.func_175019_b().func_178267_a( te.func_145831_w(), pressModel, blockState, te.func_174877_v(), buffer, false );

        buffer.func_178969_c( 0, 0, 0 );

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b( x, y, z );

        // Apply GL transformations relative to the center of the block: 1) TE rotation and 2) crank rotation
        float move = (te.getField(0) / (float)(Configs.general.pointsForPress > 0 ? Configs.general.pointsForPress: 1));
        GlStateManager.func_179137_b( 0.5, 0.5, 0.5 );
        GlStateManager.func_179137_b( 0, -( 0.58 * move), 0 );
        GlStateManager.func_179137_b( -0.5, -0.5, -0.5 );

        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        buffer.func_178969_c(0.0D, 0.0D, 0.0D);
        postDestroyRender(destroyStage);
        RenderHelper.func_74519_b();

        if (!(blockState.func_177230_c() instanceof BlockHPBase)) return;

        if (te.hasWorker())
            renderLeash(te.getWorker(), x, y, z, 0D, 0.4D, 0D, partialTicks, te.func_174877_v());

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b(x, y, z);
        if (!te.getStackInSlot(0).func_190926_b() && move <= 0.25) {
            renderItem(te, te.getStackInSlot(0), 0.5F, 0.5F, 0.5F, 1F);
            drawString(te, String.valueOf(te.getStackInSlot(0).func_190916_E()), 0, 0.35, 0);
        }

        if (!te.getStackInSlot(1).func_190926_b() && move <= 0.25) {
            renderItem(te, te.getStackInSlot(1), 0.5F, 0.5F, 0.5F, 1F);
            drawString(te, String.valueOf(te.getStackInSlot(1).func_190916_E()), 0, 0.35,  0);
        }
        GlStateManager.func_179121_F();

        GlStateManager.func_179094_E();

        drawDisplayText(te, x, y + 1, z);

        if (!te.isValid())
            RenderUtils.renderInvalidArea(te.func_145831_w(), te.func_174877_v(), 0);
        GlStateManager.func_179121_F();
        }
}
