package se.gory_moon.horsepower.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityHPHorseBase;
import se.gory_moon.horsepower.util.RenderUtils;

import java.util.stream.StreamSupport;

public class ClientHandler {

    @SubscribeEvent
    public static void renderWorld(RenderWorldLastEvent event) {
        final ItemStack[] itemStack = {ItemStack.field_190927_a};
        if (Configs.client.showObstructedPlace) {
            if (StreamSupport.stream(Minecraft.func_71410_x().field_71439_g.func_184214_aD().spliterator(), false).anyMatch(stack -> !stack.func_190926_b() && isHPBlock((itemStack[0] = stack).func_77973_b()))) {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK)
                    return;

                int offset = 0;
                if (!itemStack[0].func_190926_b() && ((ItemBlock) itemStack[0].func_77973_b()).func_179223_d() instanceof BlockGrindstone)
                    offset = -1;

                EnumFacing enumFacing = mc.field_71476_x.field_178784_b;
                BlockPos pos = mc.field_71476_x.func_178782_a();
                if (!mc.field_71441_e.func_180495_p(pos).func_177230_c().func_176200_f(mc.field_71441_e, pos))
                    pos = pos.func_177972_a(enumFacing);
                if (offset == 0 && !mc.field_71441_e.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f(mc.field_71441_e, pos.func_177984_a()))
                    pos = pos.func_177977_b();

                RenderUtils.renderUsedArea(mc.field_71441_e, pos, offset, 0.15F, 0.05F);
            }
        }
    }

    private static boolean isHPBlock(Item item) {
        if (item instanceof ItemBlock && ((ItemBlock) item).func_179223_d() instanceof BlockHPBase) {
            if (TileEntityHPHorseBase.class.isAssignableFrom(((BlockHPBase) ((ItemBlock) item).func_179223_d()).getTileClass()))
                return true;
        }
        return false;
    }
}
