/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.items;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import se.gory_moon.horsepower.blocks.ModBlocks;

public class ItemBlockChopper
extends ItemBlock {
    public ItemBlockChopper(Block block) {
        super(block);
    }

    public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = worldIn.getBlockState(pos);
        Block block = iblockstate.getBlock();
        if (!block.isReplaceable((IBlockAccess)worldIn, pos)) {
            pos = pos.offset(facing);
        }
        if (facing == EnumFacing.DOWN || !worldIn.getBlockState(pos.up()).getBlock().isReplaceable((IBlockAccess)worldIn, pos.up())) {
            pos = pos.down();
        }
        BlockPos posUp = pos.up();
        ItemStack itemstack = player.getHeldItem(hand);
        if (!itemstack.isEmpty() && player.canPlayerEdit(pos, facing, itemstack) && worldIn.mayPlace(this.block, pos, false, facing, null) && player.canPlayerEdit(posUp, facing, itemstack) && worldIn.mayPlace((Block)ModBlocks.BLOCK_CHOPPER_FILLER, pos, false, facing, null)) {
            int i = this.getMetadata(itemstack.getMetadata());
            IBlockState blockState = this.block.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            IBlockState blockStateUp = ModBlocks.BLOCK_CHOPPER_FILLER.getStateForPlacement(worldIn, posUp, facing, hitX, hitY, hitZ, EnumFacing.DOWN.getIndex(), (EntityLivingBase)player, hand);
            if (this.placeBlockAt(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, blockState)) {
                this.placeBlockAt(itemstack, player, worldIn, posUp, facing, hitX, hitY, hitZ, blockStateUp);
                SoundType soundtype = worldIn.getBlockState(pos).getBlock().getSoundType(worldIn.getBlockState(pos), worldIn, pos, (Entity)player);
                worldIn.playSound(player, pos, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                itemstack.shrink(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }
}

