package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.util.Localization;

import javax.annotation.Nullable;
import java.awt.*;

public class TileEntityGrindstone extends TileEntityHPHorseBase {

    private int currentItemMillTime;
    private int totalItemMillTime;

    public ItemStack renderStack = ItemStack.field_190927_a;
    public Color grindColor;

    public TileEntityGrindstone() {
        super(3);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("millTime", currentItemMillTime);
        compound.func_74768_a("totalMillTime", totalItemMillTime);

        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);

        if (getStackInSlot(0).func_190916_E() > 0) {
            currentItemMillTime = compound.func_74762_e("millTime");
            totalItemMillTime = compound.func_74762_e("totalMillTime");
        } else {
            currentItemMillTime = 0;
            totalItemMillTime = 1;
        }
    }

    @Override
    public void func_70296_d() {
        if (getStackInSlot(1).func_190926_b() && getStackInSlot(2).func_190926_b())
            BlockGrindstone.setState(false, field_145850_b, field_174879_c);

        if (getStackInSlot(0).func_190926_b())
            currentItemMillTime = 0;

        super.func_70296_d();
    }

    @Override
    public boolean validateArea() {
        if (searchPos == null) {
            searchPos = Lists.newArrayList();

            for (int x = -3; x <= 3; x++) {
                for (int z = -3; z <= 3; z++) {
                    if ((x <= 1 && x >= -1) && (z <= 1 && z >= -1))
                        continue;
                    searchPos.add(func_174877_v().func_177982_a(x, 0, z));
                    searchPos.add(func_174877_v().func_177982_a(x, -1, z));
                }
            }
        }

        for (BlockPos pos: searchPos) {
            if (!func_145831_w().func_180495_p(pos).func_177230_c().func_176200_f(field_145850_b, pos))
                return false;
        }
        return true;
    }

    @Override
    public boolean targetReached() {
        currentItemMillTime++;

        if (currentItemMillTime >= totalItemMillTime) {
            currentItemMillTime = 0;

            totalItemMillTime = HPRecipes.instance().getGrindstoneTime(getStackInSlot(0), false);
            millItem();
            return true;
        }
        return false;
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getGrindstoneRecipe(getStackInSlot(0), false);
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getGrindstoneResult(getStackInSlot(0), false);
    }

    @Override
    public int getPositionOffset() {
        return -1;
    }

    private void millItem() {
        if (canWork()) {
            HPRecipeBase recipe = getRecipe();
            ItemStack result = recipe.getOutput();
            ItemStack secondary = recipe.getSecondary();

            ItemStack input = getStackInSlot(0);
            ItemStack output = getStackInSlot(1);
            ItemStack secondaryOutput = getStackInSlot(2);

            if (output.func_190926_b()) {
                setInventorySlotContents(1, result.func_77946_l());
            } else if (output.func_77969_a(result)) {
                output.func_190917_f(result.func_190916_E());
            }
            TileEntityHandGrindstone.processSecondaries(func_145831_w(), secondary, secondaryOutput, recipe, this);

            input.func_190918_g(1);
            BlockGrindstone.setState(true, field_145850_b, field_174879_c);
        }
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        ItemStack itemstack = getStackInSlot(index);
        super.setInventorySlotContents(index, stack);

        if ((index == 1 || index == 2) && getStackInSlot(1).func_190926_b() && getStackInSlot(2).func_190926_b())
            BlockGrindstone.setState(false, field_145850_b, field_174879_c);

        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a(stack, itemstack);
        if (index == 0 && !flag) {
            totalItemMillTime = HPRecipes.instance().getGrindstoneTime(stack, false);
            currentItemMillTime = 0;
        }
        func_70296_d();
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index == 0 && HPRecipes.instance().hasGrindstoneRecipe(stack, false);
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0:
                return totalItemMillTime;
            case 1:
                return currentItemMillTime;
            default:
                return 0;
        }
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0:
                totalItemMillTime = value;
                break;
            case 1:
                currentItemMillTime = value;
        }
    }

    @Override
    public int getFieldCount() {
        return 2;
    }

    @Override
    public String getName() {
        return "container.mill";
    }

    @Override
    public int getOutputSlot() {
        return 2;
    }

    @Nullable
    @Override
    public ITextComponent func_145748_c_() {
        if (valid)
            return super.func_145748_c_();
        else
            return new TextComponentTranslation(Localization.INFO.GRINDSTONE_INVALID.key()).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }
}
