package se.gory_moon.horsepower.util.color;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import javax.annotation.Nullable;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Copied and modified from JEI (JustEnoughItems)
 * @author Mezz
 */
@SideOnly(Side.CLIENT)
public final class ColorGetter {

    private ColorGetter() {

    }

    public static List<Color> getColors(ItemStack itemStack, int colorCount) {
        try {
            return unsafeGetColors(itemStack, colorCount);
        } catch (RuntimeException ignored) {
            return Collections.emptyList();
        } catch (LinkageError ignored) {
            return Collections.emptyList();
        }
    }

    private static List<Color> unsafeGetColors(ItemStack itemStack, int colorCount) {
        final Item item = itemStack.func_77973_b();
        if (itemStack.func_190926_b()) {
            return Collections.emptyList();
        } else if (item instanceof ItemBlock) {
            final ItemBlock itemBlock = (ItemBlock) item;
            final Block block = itemBlock.func_179223_d();
            //noinspection ConstantConditions
            if (block == null) {
                return Collections.emptyList();
            }
            return getBlockColors(itemStack, block, colorCount);
        } else {
            return getItemColors(itemStack, colorCount);
        }
    }

    private static List<Color> getItemColors(ItemStack itemStack, int colorCount) {
        final ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        final int renderColor = itemColors.func_186728_a(itemStack, 0);
        final TextureAtlasSprite textureAtlasSprite = getTextureAtlasSprite(itemStack);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return getColors(textureAtlasSprite, renderColor, colorCount);
    }

    private static List<Color> getBlockColors(ItemStack itemStack, Block block, int colorCount) {
        final int meta = itemStack.func_77960_j();
        IBlockState blockState;
        try {
            blockState = block.func_176203_a(meta);
        } catch (RuntimeException ignored) {
            blockState = block.func_176223_P();
        } catch (LinkageError ignored) {
            blockState = block.func_176223_P();
        }

        final BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        final int renderColor = blockColors.func_186724_a(blockState, null, null, 0);
        final TextureAtlasSprite textureAtlasSprite = getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return getColors(textureAtlasSprite, renderColor, colorCount);
    }

    public static List<Color> getColors(TextureAtlasSprite textureAtlasSprite, int renderColor, int colorCount) {
        final BufferedImage bufferedImage = getBufferedImage(textureAtlasSprite);
        if (bufferedImage == null) {
            return Collections.emptyList();
        }
        final List<Color> colors = new ArrayList<Color>(colorCount);
        final int[][] palette = ColorThief.getPalette(bufferedImage, colorCount);
        if (palette != null) {
            for (int[] colorInt : palette) {
                int red = (int) ((colorInt[0] - 1) * (float) (renderColor >> 16 & 255) / 255.0F);
                int green = (int) ((colorInt[1] - 1) * (float) (renderColor >> 8 & 255) / 255.0F);
                int blue = (int) ((colorInt[2] - 1) * (float) (renderColor & 255) / 255.0F);
                red = MathHelper.func_76125_a(red, 0 ,255);
                green = MathHelper.func_76125_a(green, 0, 255);
                blue = MathHelper.func_76125_a(blue, 0, 255);
                Color color = new Color(red, green, blue);
                colors.add(color);
            }
        }
        return colors;
    }

    @Nullable
    private static BufferedImage getBufferedImage(TextureAtlasSprite textureAtlasSprite) {
        final int iconWidth = textureAtlasSprite.func_94211_a();
        final int iconHeight = textureAtlasSprite.func_94216_b();
        final int frameCount = textureAtlasSprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }

        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, BufferedImage.TYPE_4BYTE_ABGR);
        for (int i = 0; i < frameCount; i++) {
            int[][] frameTextureData = textureAtlasSprite.func_147965_a(i);
            int[] largestMipMapTextureData = frameTextureData[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
        }

        return bufferedImage;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(IBlockState blockState) {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.func_178122_a(blockState);
        if (textureAtlasSprite == minecraft.func_147117_R().func_174944_f()) {
            return null;
        }
        return textureAtlasSprite;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(ItemStack itemStack) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        ItemModelMesher itemModelMesher = renderItem.func_175037_a();
        IBakedModel itemModel = itemModelMesher.func_178089_a(itemStack);
        return itemModel.func_177554_e();
    }
}
