/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tweaker.recipes;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.recipes.PressRecipe;
import se.gory_moon.horsepower.tweaker.TweakerPluginImpl;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.horsepower.Press")
public class PressRecipeTweaker {
    @ZenMethod
    public static void add(IIngredient input, IItemStack output) {
        List items = input.getItems();
        if (items == null) {
            HorsePowerMod.logger.error("Cannot turn " + input.toString() + " into a press recipe");
        }
        ItemStack[] items2 = CraftTweakerMC.getItemStacks((List)items);
        ItemStack output2 = CraftTweakerMC.getItemStack((IItemStack)output);
        AddPressRecipe recipe = new AddPressRecipe(input, items2, output2, ItemStack.field_190927_a, 0, 0);
        CraftTweakerAPI.apply((IAction)recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        ArrayList toRemove = Lists.newArrayList();
        ArrayList removeIndex = Lists.newArrayList();
        for (int i = 0; i < HPRecipes.instance().getGrindstoneRecipes().size(); ++i) {
            PressRecipe recipe = HPRecipes.instance().getPressRecipes().get(i);
            if (!OreDictionary.itemMatches((ItemStack)CraftTweakerMC.getItemStack((IIngredient)output), (ItemStack)recipe.getOutput(), (boolean)false)) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        RemovePressRecipe recipe = new RemovePressRecipe(toRemove, removeIndex);
        CraftTweakerAPI.apply((IAction)recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    private static class RemovePressRecipe
    implements IAction {
        private final List<Integer> removingIndices;
        private final List<PressRecipe> recipes;

        private RemovePressRecipe(List<PressRecipe> recipes, List<Integer> removingIndices) {
            this.recipes = recipes;
            this.removingIndices = removingIndices;
        }

        public void apply() {
            ArrayList<PressRecipe> recipeList = HPRecipes.instance().getPressRecipes();
            for (int i = this.removingIndices.size() - 1; i >= 0; --i) {
                recipeList.remove(this.removingIndices.get(i));
            }
        }

        public String describe() {
            return "Removing " + this.recipes.size() + " press recipes";
        }
    }

    private static class AddPressRecipe
    implements IAction {
        private final IIngredient ingredient;
        private final ItemStack[] input;
        private final ItemStack output;
        private final ItemStack secondary;
        private final int secondaryChance;
        private final int time;

        public AddPressRecipe(IIngredient ingredient, ItemStack[] inputs, ItemStack output2, ItemStack secondary, int secondaryChance, int time) {
            this.ingredient = ingredient;
            this.input = inputs;
            this.output = output2;
            this.secondary = secondary;
            this.secondaryChance = secondaryChance;
            this.time = time;
        }

        public void apply() {
            for (ItemStack stack : this.input) {
                PressRecipe recipe = new PressRecipe(stack, this.output, this.secondary, this.secondary.func_190926_b() ? 0 : this.secondaryChance, this.time);
                HPRecipes.instance().addPressRecipe(recipe);
            }
        }

        public String describe() {
            return "Adding press recipe for " + this.ingredient;
        }
    }
}

