/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei.press;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.jei.HorsePowerPlugin;
import se.gory_moon.horsepower.recipes.PressRecipe;
import se.gory_moon.horsepower.util.color.Colors;

public class PressRecipeWrapper
extends BlankRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final ItemStack output;
    private final double printLaps;
    private final IDrawableAnimated arrow;

    public PressRecipeWrapper(PressRecipe recipe) {
        this(Collections.singletonList(recipe.getInput()), recipe.getOutput());
    }

    public PressRecipeWrapper(List<ItemStack> inputs, ItemStack output) {
        this.inputs = Collections.singletonList(inputs);
        this.output = output;
        IGuiHelper guiHelper = HorsePowerPlugin.guiHelper;
        ResourceLocation location = new ResourceLocation("horsepower", "textures/gui/jei.png");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, 146, 0, 24, 17);
        double time = Configs.general.pointsForPress > 0 ? Configs.general.pointsForPress : 1;
        int laps = (int)(time / 8.0 * 100.0);
        this.printLaps = (double)Math.round(time / 8.0 * 100.0) / 100.0;
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, laps, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 55 && mouseY >= 21 && mouseX < 80 && mouseY < 33) {
            tooltip.add("Time to press: " + this.printLaps + " lap" + (this.printLaps >= 2.0 ? "s" : ""));
        }
        return tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.arrow.draw(minecraft, 57, 32);
        minecraft.fontRenderer.drawStringWithShadow("x" + this.printLaps, 58.0f, 23.0f, Colors.WHITE.getRGB());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PressRecipeWrapper)) {
            return false;
        }
        PressRecipeWrapper that = (PressRecipeWrapper)((Object)o);
        boolean flag = true;
        for (ItemStack stack : this.inputs.get(0)) {
            for (ItemStack stack1 : that.inputs.get(0)) {
                if (stack1.getMetadata() != Short.MAX_VALUE || OreDictionary.itemMatches((ItemStack)stack, (ItemStack)stack1, (boolean)false)) continue;
                flag = false;
            }
        }
        return flag && this.output.equals(that.output);
    }

    public int hashCode() {
        int result = this.inputs.hashCode();
        result = 31 * result + this.output.hashCode();
        return result;
    }
}

