/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.waila;

import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.IWailaTooltipRenderer;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockChoppingBlock;
import se.gory_moon.horsepower.blocks.BlockFiller;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.blocks.BlockHPChoppingBase;
import se.gory_moon.horsepower.blocks.BlockHandGrindstone;
import se.gory_moon.horsepower.blocks.ModBlocks;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;
import se.gory_moon.horsepower.tileentity.TileEntityFiller;
import se.gory_moon.horsepower.tileentity.TileEntityGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityHPBase;
import se.gory_moon.horsepower.tileentity.TileEntityHandGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityManualChopper;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.waila.TTRenderStack;

public class Provider
implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar registrar) {
        Provider provider = new Provider();
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockGrindstone.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockHandGrindstone.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockHPChoppingBase.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockFiller.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockGrindstone.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockHandGrindstone.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockChopper.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockChoppingBlock.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, BlockFiller.class);
        registrar.addConfig("Horse Power", "horsepower:showItems", Localization.WAILA.SHOW_ITEMS.translate(new String[0]));
        registrar.registerTooltipRenderer("horsepower.stack", (IWailaTooltipRenderer)new TTRenderStack());
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock().equals((Object)ModBlocks.BLOCK_CHOPPER_FILLER)) {
            return accessor.getBlock().getPickBlock(accessor.getBlockState(), accessor.getMOP(), accessor.getWorld(), accessor.getPosition(), accessor.getPlayer());
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound nbt = accessor.getNBTData();
        if (nbt.func_150297_b("horsepower:grindstone", 10)) {
            nbt = nbt.func_74775_l("horsepower:grindstone");
            double total = nbt.func_74762_e("totalMillTime");
            double current = nbt.func_74762_e("millTime");
            double progress = (double)Math.round(current / total * 100.0 * 100.0) / 100.0;
            currenttip.add(Localization.WAILA.GRINDSTONE_PROGRESS.translate(String.valueOf(progress) + "%"));
        } else if (nbt.func_150297_b("horsepower:chopper", 10)) {
            nbt = nbt.func_74775_l("horsepower:chopper");
            double totalWindup = Configs.general.pointsForWindup > 0 ? (double)Configs.general.pointsForWindup : 1.0;
            double windup = nbt.func_74762_e("currentWindup");
            double current = nbt.func_74762_e("chopTime");
            double total = nbt.func_74762_e("totalChopTime");
            double progressWindup = (double)Math.round(windup / totalWindup * 100.0 * 100.0) / 100.0;
            double progressChopping = (double)Math.round(current / total * 100.0 * 100.0) / 100.0;
            if (accessor.getTileEntity() instanceof TileEntityChopper || accessor.getTileEntity() instanceof TileEntityFiller) {
                currenttip.add(Localization.WAILA.WINDUP_PROGRESS.translate(String.valueOf(progressWindup) + "%"));
            }
            if (total > 1.0 || accessor.getTileEntity() instanceof TileEntityManualChopper) {
                currenttip.add(Localization.WAILA.CHOPPING_PROGRESS.translate(String.valueOf(progressChopping) + "%"));
            }
        }
        if (accessor.getTileEntity() instanceof TileEntityHPBase && accessor.getPlayer().func_70093_af() && config.getConfig("horsepower:showItems")) {
            ItemStack stack = ((TileEntityHPBase)accessor.getTileEntity()).getStackInSlot(0);
            String name = String.valueOf(stack.func_77973_b().getRegistryName().toString());
            if (!stack.func_190926_b()) {
                currenttip.add(SpecialChars.getRenderString((String)"horsepower.stack", (String[])new String[]{"1", name, String.valueOf(stack.func_190916_E()), String.valueOf(stack.func_77952_i()), String.valueOf(Base64.getEncoder().encodeToString(stack.serializeNBT().toString().getBytes(Charset.forName("UTF-8"))))}) + SpecialChars.TAB + SpecialChars.WHITE + stack.func_82833_r());
            }
            stack = ((TileEntityHPBase)accessor.getTileEntity()).getStackInSlot(1);
            name = String.valueOf(stack.func_77973_b().getRegistryName().toString());
            if (!stack.func_190926_b()) {
                currenttip.add(SpecialChars.getRenderString((String)"horsepower.stack", (String[])new String[]{"1", name, String.valueOf(stack.func_190916_E()), String.valueOf(stack.func_77952_i()), String.valueOf(Base64.getEncoder().encodeToString(stack.serializeNBT().toString().getBytes(Charset.forName("UTF-8"))))}) + SpecialChars.TAB + SpecialChars.WHITE + stack.func_82833_r());
            }
            stack = ((TileEntityHPBase)accessor.getTileEntity()).getStackInSlot(2);
            name = String.valueOf(stack.func_77973_b().getRegistryName().toString());
            if (!stack.func_190926_b()) {
                currenttip.add(SpecialChars.getRenderString((String)"horsepower.stack", (String[])new String[]{"1", name, String.valueOf(stack.func_190916_E()), String.valueOf(stack.func_77952_i()), String.valueOf(Base64.getEncoder().encodeToString(stack.serializeNBT().toString().getBytes(Charset.forName("UTF-8"))))}) + SpecialChars.TAB + SpecialChars.WHITE + stack.func_82833_r());
            }
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        NBTTagCompound tile = new NBTTagCompound();
        if (te instanceof TileEntityFiller) {
            te = ((TileEntityFiller)te).getFilledTileEntity();
        }
        if (te != null) {
            te.func_189515_b(tile);
        }
        if (te instanceof TileEntityGrindstone || te instanceof TileEntityHandGrindstone) {
            tag.func_74782_a("horsepower:grindstone", (NBTBase)tile);
        } else if (te instanceof TileEntityChopper || te instanceof TileEntityManualChopper) {
            tag.func_74782_a("horsepower:chopper", (NBTBase)tile);
        }
        return tag;
    }
}

