/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tweaker.recipes;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tweaker.TweakerPluginImpl;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.horsepower.Grindstone")
public class GrindstoneRecipeTweaker {
    @ZenMethod
    public static void add(IIngredient input, IItemStack output, int time, @Optional boolean hand, @Optional IItemStack secondary, @Optional int secondaryChance) {
        List items = input.getItems();
        if (items == null) {
            HorsePowerMod.logger.error("Cannot turn " + input.toString() + " into a grinding recipe");
        }
        ItemStack[] items2 = CraftTweakerMC.getItemStacks((List)items);
        ItemStack output2 = CraftTweakerMC.getItemStack((IItemStack)output);
        ItemStack secondary2 = CraftTweakerMC.getItemStack((IItemStack)secondary);
        AddGrindstoneRecipe recipe = new AddGrindstoneRecipe(input, items2, output2, secondary2, secondaryChance, time, hand);
        CraftTweakerAPI.apply((IAction)recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    @ZenMethod
    public static void remove(IIngredient output, @Optional boolean hand) {
        ArrayList toRemove = Lists.newArrayList();
        ArrayList removeIndex = Lists.newArrayList();
        for (int i = 0; i < HPRecipes.instance().getGrindstoneRecipes().size(); ++i) {
            GrindstoneRecipe recipe = HPRecipes.instance().getGrindstoneRecipes().get(i);
            if (!OreDictionary.itemMatches((ItemStack)CraftTweakerMC.getItemStack((IIngredient)output), (ItemStack)recipe.getOutput(), (boolean)false)) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        RemoveGrindstoneRecipe recipe = new RemoveGrindstoneRecipe(toRemove, removeIndex, hand);
        CraftTweakerAPI.apply((IAction)recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    private static class RemoveGrindstoneRecipe
    implements IAction {
        private final List<Integer> removingIndices;
        private final List<GrindstoneRecipe> recipes;
        private final boolean hand;

        private RemoveGrindstoneRecipe(List<GrindstoneRecipe> recipes, List<Integer> removingIndices, boolean hand) {
            this.recipes = recipes;
            this.removingIndices = removingIndices;
            this.hand = hand;
        }

        public void apply() {
            ArrayList<GrindstoneRecipe> grindRecipe = this.hand && Configs.recipes.useSeperateGrindstoneRecipes ? HPRecipes.instance().getHandGrindstoneRecipes() : HPRecipes.instance().getGrindstoneRecipes();
            for (int i = this.removingIndices.size() - 1; i >= 0; --i) {
                grindRecipe.remove(this.removingIndices.get(i));
            }
        }

        public String describe() {
            return "Removing " + this.recipes.size() + " grindstone recipes";
        }
    }

    private static class AddGrindstoneRecipe
    implements IAction {
        private final IIngredient ingredient;
        private final ItemStack[] input;
        private final ItemStack output;
        private final ItemStack secondary;
        private final int secondaryChance;
        private final int time;
        private final boolean hand;

        public AddGrindstoneRecipe(IIngredient ingredient, ItemStack[] inputs, ItemStack output2, ItemStack secondary, int secondaryChance, int time, boolean hand) {
            this.ingredient = ingredient;
            this.input = inputs;
            this.output = output2;
            this.secondary = secondary;
            this.secondaryChance = secondaryChance;
            this.time = time;
            this.hand = hand;
        }

        public void apply() {
            for (ItemStack stack : this.input) {
                GrindstoneRecipe recipe = new GrindstoneRecipe(stack, this.output, this.secondary, this.secondary.func_190926_b() ? 0 : this.secondaryChance, this.time);
                HPRecipes.instance().addGrindstoneRecipe(recipe, this.hand);
            }
        }

        public String describe() {
            return "Adding grindstone recipe for " + this.ingredient;
        }
    }
}

