package se.gory_moon.horsepower.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import se.gory_moon.horsepower.util.Utils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class TileEntityHPHorseBase extends TileEntityHPBase implements ITickable{

    protected static double[][] path = {{-1.5, -1.5}, {0, -1.5}, {1, -1.5}, {1, 0}, {1, 1}, {0, 1}, {-1.5, 1}, {-1.5, 0}};
    protected AxisAlignedBB[] searchAreas = new AxisAlignedBB[8];
    protected List<BlockPos> searchPos = null;
    protected int origin = -1;
    protected int target = origin;

    protected boolean hasWorker = false;
    protected EntityCreature worker;
    protected NBTTagCompound nbtWorker;

    protected boolean valid = false;
    protected int validationTimer = 0;
    protected int locateHorseTimer = 0;
    protected boolean running = true;
    protected boolean wasRunning = false;

    public TileEntityHPHorseBase(int inventorySize) {
        super(inventorySize);
    }

    public abstract boolean validateArea();

    public abstract boolean targetReached();

    public abstract int getPositionOffset();

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);

        target = compound.func_74762_e("target");
        origin = compound.func_74762_e("origin");
        hasWorker = compound.func_74767_n("hasWorker");

        if (hasWorker && compound.func_150297_b("leash", 10)) {
            nbtWorker = compound.func_74775_l("leash");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("target", target);
        compound.func_74768_a("origin", origin);
        compound.func_74757_a("hasWorker", hasWorker);

        if (this.worker != null) {
            if (nbtWorker == null) {
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                UUID uuid = worker.func_110124_au();
                nbtTagCompound.func_186854_a("UUID", uuid);
                nbtWorker = nbtTagCompound;
            }

            compound.func_74782_a("leash", nbtWorker);
        }

        return super.func_189515_b(compound);
    }

    public void setWorker(EntityCreature newWorker) {
        hasWorker = true;
        worker = newWorker;
        worker.func_175449_a(field_174879_c, 3);
        target = getClosestTarget();
        if (worker != null) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            UUID uuid = worker.func_110124_au();
            nbtTagCompound.func_186854_a("UUID", uuid);
            nbtWorker = nbtTagCompound;
        }
    }

    public void setWorkerToPlayer(EntityPlayer player) {
        if (hasWorker() && worker.func_184652_a(player)) {
            hasWorker = false;
            worker.func_110177_bN();
            worker.func_110162_b(player, true);
            worker = null;
            nbtWorker = null;
        }
    }

    public boolean hasWorker() {
        if (worker != null && !worker.field_70128_L && !worker.func_110167_bD() && worker.func_174818_b(field_174879_c) < 45) {
            return true;
        } else {
            if (worker != null) {
                worker = null;
                if (!func_145831_w().field_72995_K)
                    InventoryHelper.func_180173_a(field_145850_b, field_174879_c.func_177958_n(), field_174879_c.func_177956_o() + 1, field_174879_c.func_177952_p(), new ItemStack(Items.field_151058_ca));
            }
            hasWorker = false;
            return false;
        }
    }

    public EntityCreature getWorker() {
        return worker;
    }

    private Vec3d getPathPosition(int i) {
        double x = field_174879_c.func_177958_n() + path[i][0] * 2;
        double y = field_174879_c.func_177956_o() + getPositionOffset();
        double z = field_174879_c.func_177952_p() + path[i][1] * 2;
        return new Vec3d(x, y, z);
    }

    protected int getClosestTarget() {
        if (hasWorker()) {
            double dist = Double.MAX_VALUE;
            int closest = 0;

            for (int i = 0; i < path.length; i++) {
                Vec3d pos = getPathPosition(i);
                double x = pos.field_72450_a;
                double y = pos.field_72448_b;
                double z = pos.field_72449_c;

                double tmp = worker.func_70011_f(x, y, z);
                if (tmp < dist) {
                    dist = tmp;
                    closest = i;
                }
            }

            return closest;
        }
        return 0;
    }

    @Override
    public void func_73660_a() {
        validationTimer--;
        if (validationTimer <= 0) {
            valid = validateArea();
            if (valid)
                validationTimer = 220;
            else
                validationTimer = 60;
        }

        if (!hasWorker())
            locateHorseTimer--;
        if (!hasWorker() && nbtWorker != null && locateHorseTimer <= 0) {
            UUID uuid = nbtWorker.func_186857_a("UUID");
            int x = field_174879_c.func_177958_n();
            int y = field_174879_c.func_177956_o();
            int z = field_174879_c.func_177952_p();

            ArrayList<Class<? extends EntityCreature>> clazzes = Utils.getCreatureClasses();
            search: for (Class<? extends Entity> clazz: clazzes) {
                for (Object entity : field_145850_b.func_72872_a(clazz, new AxisAlignedBB((double)x - 7.0D, (double)y - 7.0D, (double)z - 7.0D, (double)x + 7.0D, (double)y + 7.0D, (double)z + 7.0D))){
                    if (entity instanceof EntityCreature) {
                        EntityCreature creature = (EntityCreature) entity;
                        if (creature.func_110124_au().equals(uuid)) {
                            setWorker(creature);
                            break search;
                        }
                    }
                }
            }
        }
        if (locateHorseTimer <= 0)
            locateHorseTimer = 220;

        boolean flag = false;

        if (!field_145850_b.field_72995_K && valid) {
            if (!running && canWork()) {
                running = true;
            } else if (running && !canWork()){
                running = false;
            }

            if (running != wasRunning) {
                target = getClosestTarget();
                wasRunning = running;
            }

            if (hasWorker()) {
                if (running) {

                    Vec3d pos = getPathPosition(target);
                    double x = pos.field_72450_a;
                    double y = pos.field_72448_b;
                    double z = pos.field_72449_c;

                    if (searchAreas[target] == null)
                        searchAreas[target] = new AxisAlignedBB(x - 0.5D, y - 0.5D, z - 0.5D, x + 0.5D, y + 0.5D, z + 0.5D);

                    if (worker.func_174813_aQ().func_72326_a(searchAreas[target])) {
                        int next = target + 1;
                        int previous = target -1;
                        if (next >= path.length)
                            next = 0;
                        if (previous < 0)
                            previous = path.length - 1;

                        if (origin != target && target != previous) {
                            origin = target;
                            flag = targetReached();
                        }
                        target = next;
                    }

                    if (worker instanceof AbstractHorse && ((AbstractHorse)worker).func_110204_cc()) {
                        ((AbstractHorse)worker).func_110227_p(false);
                    }

                    if (target != -1 && worker.func_70661_as().func_75500_f()) {
                        pos = getPathPosition(target);
                        x = pos.field_72450_a;
                        y = pos.field_72448_b;
                        z = pos.field_72449_c;

                        worker.func_70661_as().func_75492_a(x, y, z, 1D);
                    }

                }
            }
        }

        if (flag) {
            func_70296_d();
        }
    }
}
