package se.gory_moon.horsepower.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import se.gory_moon.horsepower.recipes.HPRecipeBase;

import javax.annotation.Nullable;

public abstract class TileEntityHPBase extends TileEntity {

    protected NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a(3, ItemStack.field_190927_a);
    protected IHPInventory inventory;

    private EnumFacing forward = null;

    public TileEntityHPBase(int inventorySize) {
        itemStacks = NonNullList.func_191197_a(inventorySize, ItemStack.field_190927_a);

        inventory = new IHPInventory() {
            @Override
            public int func_70302_i_() {
                return itemStacks.size();
            }

            @Override
            public boolean func_191420_l() {
                for (ItemStack itemstack : itemStacks) {
                    if (!itemstack.func_190926_b()) {
                        return false;
                    }
                }

                return true;
            }

            @Override
            public ItemStack func_70301_a(int index) {
                if (index >= itemStacks.size()) return ItemStack.field_190927_a;
                return itemStacks.get(index);
            }

            @Override
            public ItemStack func_70298_a(int index, int count) {
                ItemStack stack = ItemStackHelper.func_188382_a(itemStacks, index, count);
                if (!stack.func_190926_b())
                    func_70296_d();
                return stack;
            }

            @Override
            public ItemStack func_70304_b(int index) {
                ItemStack stack = ItemStackHelper.func_188383_a(itemStacks, index);
                return stack;
            }

            @Override
            public void func_70299_a(int index, ItemStack stack) {
                TileEntityHPBase.this.setInventorySlotContents(index, stack);
            }

            @Override
            public void setSlotContent(int index, ItemStack stack) {
                itemStacks.set(index, stack);

                if (index == 0 && stack.func_190916_E() > this.func_70297_j_()) {
                    stack.func_190920_e(this.func_70297_j_());
                }
            }

            @Override
            public int func_70297_j_() {
                return TileEntityHPBase.this.getInventoryStackLimit();
            }

            @Override
            public void func_70296_d() {
                TileEntityHPBase.this.func_70296_d();
            }

            @Override
            public boolean func_70300_a(EntityPlayer player) {
                return func_145831_w().func_175625_s(func_174877_v()) == TileEntityHPBase.this && player.func_70092_e((double) func_174877_v().func_177958_n() + 0.5D, (double) func_174877_v().func_177956_o() + 0.5D, (double) func_174877_v().func_177952_p() + 0.5D) <= 64.0D;
            }

            @Override
            public void func_174889_b(EntityPlayer player) {}

            @Override
            public void func_174886_c(EntityPlayer player) {}

            @Override
            public boolean func_94041_b(int index, ItemStack stack) {
                return TileEntityHPBase.this.isItemValidForSlot(index, stack);
            }

            @Override
            public int func_174887_a_(int id) {
                return TileEntityHPBase.this.getField(id);
            }

            @Override
            public void func_174885_b(int id, int value) {TileEntityHPBase.this.setField(id, value);}

            @Override
            public int func_174890_g() {
                return TileEntityHPBase.this.getFieldCount();
            }

            @Override
            public void func_174888_l() {
                itemStacks.clear();
            }

            @Override
            public String func_70005_c_() {
                return TileEntityHPBase.this.getName();
            }

            @Override
            public boolean func_145818_k_() {
                return false;
            }

            @Override
            public ITextComponent func_145748_c_() {
                return TileEntityHPBase.this.func_145748_c_();
            }
        };
        handlerTop = new RangedWrapper(new InvWrapper(inventory), 0, 1);
        handlerBottom = new RangedWrapper(new InvWrapper(inventory), 1, getOutputSlot() + 1);
    }

    public abstract HPRecipeBase getRecipe();

    public abstract ItemStack getRecipeItemStack();

    public abstract int getInventoryStackLimit();

    public abstract boolean isItemValidForSlot(int index, ItemStack stack);

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {}

    public int getFieldCount() {
        return 0;
    }

    public abstract String getName();

    public abstract int getOutputSlot();

    public ItemStack getStackInSlot(int index) {
        return inventory.func_70301_a(index);
    }

    public ItemStack removeStackFromSlot(int index) {
        return inventory.func_70304_b(index);
    }

    public IHPInventory getInventory() {
        return inventory;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        inventory.setSlotContent(index, stack);
    }

    public int getInventoryStackLimit(ItemStack stack) {
        return getInventoryStackLimit();
    }

    public IExtendedBlockState getExtendedState(IExtendedBlockState state) {
        return state;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);

        itemStacks = NonNullList.func_191197_a(inventory.func_70302_i_(), ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b(compound, itemStacks);

        if (canBeRotated()) {
            forward = EnumFacing.func_176739_a(compound.func_74779_i("forward"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a(compound, itemStacks);

        if (canBeRotated()) {
            compound.func_74778_a("forward", getForward().func_176610_l());
        }
        return compound;
    }

    @Override
    public void func_70296_d() {
        final IBlockState state = func_145831_w().func_180495_p(func_174877_v());
        func_145831_w().func_184138_a(func_174877_v(), state, state, 2);
        super.func_70296_d();
    }

    public boolean canWork() {
        if (getStackInSlot(0).func_190926_b()) {
            return false;
        } else {
            HPRecipeBase recipeBase = getRecipe();
            if (recipeBase == null) return false;

            ItemStack itemstack = recipeBase.getOutput();
            ItemStack secondary = recipeBase.getSecondary();

            if (itemstack.func_190926_b()) {
                return false;
            } else {
                ItemStack output = getStackInSlot(1);
                ItemStack outputSecondary = secondary.func_190926_b() ? ItemStack.field_190927_a: inventory.func_70301_a(2);
                if (!secondary.func_190926_b() && !outputSecondary.func_190926_b()) {
                    if (!outputSecondary.func_77969_a(secondary)) return false;
                    if (outputSecondary.func_190916_E() + secondary.func_190916_E() > secondary.func_77976_d()) return false;
                }
                return output.func_190926_b() || output.func_77969_a(itemstack) && output.func_190916_E() + itemstack.func_190916_E() <= output.func_77976_d();
            }
        }
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77960_j() == stack2.func_77960_j() && (stack1.func_190916_E() <= stack1.func_77976_d() && ItemStack.func_77970_a(stack1, stack2)));
    }

    public boolean canBeRotated() {
        return false;
    }

    public EnumFacing getForward() {
        if (forward == null)
            return EnumFacing.NORTH;
        return forward;
    }

    public void setForward(EnumFacing forward) {
        this.forward = forward;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(func_174877_v(), -999, func_189517_E_());
    }

    @Override
    @SideOnly(Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return func_189515_b(new NBTTagCompound());
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        func_145839_a(tag);
        func_70296_d();
    }

    private IItemHandler handlerTop;
    private IItemHandler handlerBottom;

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == EnumFacing.DOWN || facing == EnumFacing.UP)) || super.hasCapability(capability, facing);
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getCapability(Capability<T> capability, @javax.annotation.Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
            if (facing == EnumFacing.DOWN)
                return (T) handlerBottom;
            else if (facing == EnumFacing.UP)
                return (T) handlerTop;
        return super.getCapability(capability, facing);
    }
}
