/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.recipes;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.ChoppingBlockRecipe;
import se.gory_moon.horsepower.recipes.GrindstoneRecipe;
import se.gory_moon.horsepower.recipes.HPRecipeBase;

public class HPRecipes {
    private static HPRecipes INSTANCE = new HPRecipes();
    private final ArrayList<GrindstoneRecipe> grindstoneRecipes = Lists.newArrayList();
    private final ArrayList<ChoppingBlockRecipe> choppingBlockRecipes = Lists.newArrayList();
    public static ArrayList<String> ERRORS = Lists.newArrayList();

    public static HPRecipes instance() {
        return INSTANCE;
    }

    private HPRecipes() {
    }

    public void reloadRecipes() {
        HorsePowerMod.jeiPlugin.removeRecipe();
        this.grindstoneRecipes.clear();
        this.choppingBlockRecipes.clear();
        this.createRecipes(GrindstoneRecipe.class, Configs.grindstoneRecipes).forEach(this::addGrindstoneRecipe);
        this.createRecipes(ChoppingBlockRecipe.class, Configs.choppingRecipes).forEach(this::addChoppingRecipe);
        HorsePowerMod.jeiPlugin.addRecipes();
        HorsePowerMod.tweakerPlugin.applyTweaker();
    }

    private <T extends HPRecipeBase> List<T> createRecipes(Class<T> clazz, String[] data) {
        ArrayList<T> recipes = new ArrayList<T>();
        for (String aData : data) {
            Object[] comp = aData.split("-");
            if (aData.isEmpty()) continue;
            ArrayList stacks = Lists.newArrayList();
            int time = -1;
            for (String string : comp) {
                if (string.contains(":")) {
                    Object stack;
                    try {
                        stack = this.parseItemStack(string);
                    }
                    catch (Exception e) {
                        this.errorMessage("Parse error with " + clazz.getSimpleName().replaceAll("Recipe", "") + " recipe item '" + string + "' from config" + (stacks.size() > 0 ? " with item" + stacks.get(0) : "") + ".");
                        break;
                    }
                    if ((!(stack instanceof ItemStack) || ((ItemStack)stack).func_190926_b()) && (stack instanceof ItemStack || stack == null)) continue;
                    stacks.add(stack);
                    continue;
                }
                if (stacks.size() != 2) continue;
                try {
                    time = Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    this.errorMessage("Parse error with " + clazz.getSimpleName().replaceAll("Recipe", "") + " recipe time '" + string + "' from config for input " + stacks.get(0) + " and output " + stacks.get(1) + ".");
                    time = -1;
                }
            }
            if (stacks.size() == 2 && time > -1) {
                try {
                    if (stacks.get(0) instanceof List) {
                        for (Object stack : (List)stacks.get(0)) {
                            ItemStack in = (ItemStack)stack;
                            in.func_190920_e(1);
                            recipes.add(clazz.getConstructor(ItemStack.class, ItemStack.class, Integer.TYPE).newInstance(in, stacks.get(1), time));
                        }
                        continue;
                    }
                    ItemStack in = (ItemStack)stacks.get(0);
                    in.func_190920_e(1);
                    recipes.add(clazz.getConstructor(ItemStack.class, ItemStack.class, Integer.TYPE).newInstance(in, stacks.get(1), time));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.errorMessage("Couldn't load " + clazz.getSimpleName().replaceAll("Recipe", "") + " recipe (" + Joiner.on((String)"-").join(comp) + ")");
        }
        return recipes;
    }

    private void errorMessage(String message) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            if (FMLClientHandler.instance().getClientPlayerEntity() != null) {
                FMLClientHandler.instance().getClientPlayerEntity().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + message));
            } else {
                ERRORS.add(message);
            }
        }
        HorsePowerMod.logger.warn(message);
    }

    private Object parseItemStack(String item) throws Exception {
        int meta;
        int amount;
        NBTTagCompound nbt;
        String[] data = item.split("\\$");
        NBTTagCompound nBTTagCompound = nbt = data.length == 1 ? null : JsonToNBT.func_180713_a((String)data[1]);
        if (data.length == 2) {
            item = item.substring(0, item.indexOf("$"));
        }
        int n = amount = (data = item.split("@")).length == 1 ? 1 : Integer.parseInt(data[1]);
        if (data.length == 2) {
            item = item.substring(0, item.indexOf("@"));
        }
        int n2 = (data = item.split(":")).length == 2 ? 0 : (meta = "*".equals(data[2]) ? Short.MAX_VALUE : Integer.parseInt(data[2]));
        if (item.startsWith("ore:")) {
            return OreDictionary.getOres((String)item.substring(4));
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("id", data[0] + ":" + data[1]);
        compound.func_74774_a("Count", (byte)amount);
        compound.func_74777_a("Damage", (short)meta);
        if (nbt != null) {
            compound.func_74782_a("tag", (NBTBase)nbt);
        }
        ItemStack stack = new ItemStack(compound);
        return stack;
    }

    public void addGrindstoneRecipe(Block input, ItemStack output, int time) {
        this.addGrindstoneRecipe(Item.func_150898_a((Block)input), output, time);
    }

    public void addGrindstoneRecipe(Item input, ItemStack output, int time) {
        this.addGrindstoneRecipe(new ItemStack(input, 1, Short.MAX_VALUE), output, time);
    }

    public void addGrindstoneRecipe(ItemStack input, ItemStack output, int time) {
        if (this.getGrindstoneResult(input) != ItemStack.field_190927_a) {
            return;
        }
        this.grindstoneRecipes.add(new GrindstoneRecipe(input, output, time));
    }

    public void addGrindstoneRecipe(GrindstoneRecipe recipe) {
        if (this.getGrindstoneResult(recipe.getInput()) != ItemStack.field_190927_a) {
            return;
        }
        this.grindstoneRecipes.add(recipe);
    }

    public void addChoppingRecipe(Block input, ItemStack output, int time) {
        this.addChoppingRecipe(Item.func_150898_a((Block)input), output, time);
    }

    public void addChoppingRecipe(Item input, ItemStack output, int time) {
        this.addChoppingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), output, time);
    }

    public void addChoppingRecipe(ItemStack input, ItemStack output, int time) {
        if (this.getChopperResult(input) != ItemStack.field_190927_a) {
            return;
        }
        this.choppingBlockRecipes.add(new ChoppingBlockRecipe(input, output, time));
    }

    public void addChoppingRecipe(ChoppingBlockRecipe recipe) {
        if (this.getChopperResult(recipe.getInput()) != ItemStack.field_190927_a) {
            return;
        }
        this.choppingBlockRecipes.add(recipe);
    }

    public void removeGrindstoneRecipe(GrindstoneRecipe recipe) {
        if (this.hasGrindstoneRecipe(recipe.getInput())) {
            this.grindstoneRecipes.remove(recipe);
        }
    }

    public void removeGrindstoneRecipe(ItemStack input) {
        if (this.hasGrindstoneRecipe(input)) {
            for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
                if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)input, (boolean)false)) continue;
                this.grindstoneRecipes.remove(recipe);
            }
        }
    }

    public void removeChoppingRecipe(ChoppingBlockRecipe recipe) {
        if (this.hasChopperRecipe(recipe.getInput())) {
            this.choppingBlockRecipes.remove(recipe);
        }
    }

    public void removeChoppingRecipe(ItemStack input) {
        if (this.hasChopperRecipe(input)) {
            for (ChoppingBlockRecipe recipe : this.choppingBlockRecipes) {
                if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)input, (boolean)false)) continue;
                this.choppingBlockRecipes.remove(recipe);
            }
        }
    }

    public ItemStack getGrindstoneResult(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getOutput();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getChopperResult(ItemStack stack) {
        for (ChoppingBlockRecipe recipe : this.choppingBlockRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getOutput();
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasGrindstoneRecipe(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChopperRecipe(ItemStack stack) {
        for (ChoppingBlockRecipe recipe : this.choppingBlockRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<GrindstoneRecipe> getGrindstoneRecipes() {
        return this.grindstoneRecipes;
    }

    public ArrayList<ChoppingBlockRecipe> getChoppingRecipes() {
        return this.choppingBlockRecipes;
    }

    public int getGrindstoneTime(ItemStack stack) {
        for (GrindstoneRecipe recipe : this.grindstoneRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getTime();
        }
        return 16;
    }

    public int getChoppingTime(ItemStack stack) {
        for (ChoppingBlockRecipe recipe : this.choppingBlockRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe.getTime();
        }
        return 1;
    }
}

